/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.core;

import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.TypeInfo;

import java.util.List;
import java.util.ArrayList;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
class ParameterizedTypeInfoImpl<T, M, A, P> extends AbstractParameterizedTypeInfo<T, M, A, P> implements ParameterizedTypeInfo {

  /** . */
  private final T type;

  /** . */
  private TypeInfo rawType;

  /** . */
  private List<TypeInfo> typeArguments;

  public ParameterizedTypeInfoImpl(TypeResolverImpl<T, M, A, P> domain, T type) {
    super(domain);

    //
    this.type = type;
    this.rawType = null;
  }

  public T unwrap() {
    return type;
  }

  public TypeInfo getRawType() {
    if (rawType == null) {
      T rawType = domain.typeModel.getRawType(type);
      this.rawType = domain._getType(rawType);
    }
    return rawType;
  }

  public List<TypeInfo> getTypeArguments() {
    if (typeArguments == null) {
      ArrayList<TypeInfo> typeArguments = new ArrayList<TypeInfo>();
      for (T typeArgument : domain.typeModel.getTypeArguments(type)) {
        AbstractTypeInfo<T, M, A, P> ta = domain._getType(typeArgument);
        typeArguments.add(ta);
      }
      this.typeArguments = typeArguments;
    }
    return typeArguments;
  }
}
