/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.jlr;

import java.lang.reflect.Method;
import java.util.Arrays;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
class MethodSignature {

  /** . */
  private final String name;

  /** . */
  private final Class<?>[] parameterTypes;

  public MethodSignature(Method method) {
    this.name = method.getName();
    this.parameterTypes = method.getParameterTypes();
  }

  public MethodSignature(String methodName, Class... parameterTypes) {
    this.name = methodName;
    this.parameterTypes = parameterTypes;
  }

  public String getName() {
    return name;
  }

  public Method getDeclaredMethod(Class declaringClass) {
    try {
      return declaringClass.getDeclaredMethod(name, parameterTypes);
    }
    catch (NoSuchMethodException e) {
      return null;
    }
  }

  @Override
  public boolean equals(Object obj) {
    if (obj == this) {
      return true;
    }
    if (obj instanceof MethodSignature) {
      MethodSignature that = (MethodSignature)obj;
      return name.equals(that.name) && Arrays.equals(parameterTypes, that.parameterTypes);
    }
    return false;
  }

  @Override
  public int hashCode() {
    return name.hashCode() ^ Arrays.hashCode(parameterTypes);
  }
}
