/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.jlr;

import org.reflext.spi.model.AnnotationModel;
import org.reflext.spi.model.MethodModel;
import org.reflext.spi.model.ReflectionModel;
import org.reflext.spi.model.TypeModel;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class JavaLangReflectReflectionModel implements ReflectionModel<Type, Method, Annotation, Method> {

  public static JavaLangReflectReflectionModel getInstance() {
    return instance;
  }

  /** . */
  private static final JavaLangReflectReflectionModel instance = new JavaLangReflectReflectionModel();

  /** . */
  private final JavaLangReflectTypeModel typeModel = new JavaLangReflectTypeModel();

  /** . */
  private final JavaLangReflectMethodModel methodModel = new JavaLangReflectMethodModel();

  /** . */
  private final JavaLangReflectTypeAnnotationModel typeAnnotationModel = new JavaLangReflectTypeAnnotationModel();

  /** . */
  private final JavaLangReflectMethodAnnotationModel methodAnnotationModel = new JavaLangReflectMethodAnnotationModel();

  public TypeModel<Type> getTypeModel() {
    return typeModel;
  }

  public MethodModel<Type, Method> getMethodModel() {
    return methodModel;
  }

  public AnnotationModel<Type, Type, Annotation, Method> getTypeAnnotationModel() {
    return typeAnnotationModel;
  }

  public AnnotationModel<Type, Method, Annotation, Method> getMethodAnnotationModel() {
    return methodAnnotationModel;
  }
}
