/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.test;

import org.reflext.core.TypeDomain;
import org.reflext.api.TypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.ClassTypeInfo;

import java.util.Map;
import java.util.HashMap;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class TypeDomainExt<T, M> {

  /** . */
  private TypeDomain<T, M> domain;

  /** . */
  private Map<String, T> types;

  public TypeDomainExt(TypeDomain<T, M> domain, Map<String, T> types) {
    this.domain = domain;
    this.types = types;
  }

  protected final TypeInfo getTypeInfo(String typeId) {
    T type = types.get(typeId);
    if (type == null) {
      throw new IllegalArgumentException("Could not find type " + typeId);
    }
    return getInfo(type);
  }

  private TypeInfo getInfo(T type) {
    return domain.getType(type);
  }

  public MethodInfo getMethodInfo(String id) {
    for (T type : types.values()) {
      TypeInfo ti = domain.getType(type);
      if (ti instanceof ClassTypeInfo) {
        for (MethodInfo mi : ((ClassTypeInfo)ti).getDeclaredMethods()) {
          org.reflext.test.Method methodAnn = mi.getDeclaredAnnotation(org.reflext.test.Method.class);
          if (methodAnn != null && methodAnn.value().equals(id)) {
            return mi;
          }
        }
      }
    }
    return null;
  }
}
