/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.test;

import junit.framework.TestCase;

import java.lang.reflect.Type;
import java.lang.reflect.Method;
import java.lang.reflect.AnnotatedElement;
import java.util.Map;
import java.util.HashMap;

import org.reflext.api.TypeResolver;
import org.reflext.core.TypeResolverImpl;
import org.reflext.jlr.*;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public abstract class AbstractTypeResolutionTestCase extends TestCase {

  /** . */
  protected TypeResolver<Type> domain = TypeResolverImpl.create(new JavaLangReflectReflectionModel(), false);

  /** . */
  protected final Map<String, Type> types = new HashMap<String, Type>();

  protected abstract void configure();

  protected abstract ReflectUnitTest getUnitTest();

  protected final void add(Class clazz) {
    org.reflext.test.Type classTypeAnn = ((AnnotatedElement)clazz).getAnnotation(org.reflext.test.Type.class);
    if (classTypeAnn != null) {
      types.put(classTypeAnn.value(), clazz);
    }
    for (Method method : clazz.getDeclaredMethods()) {
      org.reflext.test.Type methodTypeAnn = method.getAnnotation(org.reflext.test.Type.class);
      if (methodTypeAnn != null) {
        types.put(methodTypeAnn.value(), method.getGenericReturnType());
      }
    }
  }

  public void testResolver() throws Exception {

    configure();

    ReflectUnitTest a = getUnitTest();

    TypeDomainExt<Type> td = new TypeDomainExt<Type>(domain, types);

    a.run("org.reflext.jlr", td);

  }

}
