/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.test;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.reflext.test.ReflextUnitTest;
import org.reflext.test.UnitTestPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReflextTestCase
extends TestCase {
    protected final Set<Class<?>> classes = new HashSet();
    private static List<UnitTestPlugin> plugins;

    protected abstract void configure();

    protected abstract ReflextUnitTest getUnitTest();

    protected final void add(Class clazz) {
        this.classes.add(clazz);
    }

    private static List<UnitTestPlugin> getPlugins() throws Exception {
        if (plugins == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            String path = "META-INF/services/" + UnitTestPlugin.class.getName();
            Enumeration<URL> e = cl.getResources(path);
            ArrayList<UnitTestPlugin> list = new ArrayList<UnitTestPlugin>();
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                BufferedInputStream in = new BufferedInputStream(url.openStream());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int i = ((InputStream)in).read();
                while (i != -1) {
                    baos.write(i);
                    i = ((InputStream)in).read();
                }
                ((InputStream)in).close();
                baos.close();
                String fqn = baos.toString().trim();
                Class<?> clazz = cl.loadClass(fqn);
                UnitTestPlugin plugin = (UnitTestPlugin)clazz.newInstance();
                list.add(plugin);
                plugins = list;
            }
        }
        return plugins;
    }

    public void testExecute() throws Exception {
        this.configure();
        ReflextUnitTest unitTest = this.getUnitTest();
        for (UnitTestPlugin plugin : AbstractReflextTestCase.getPlugins()) {
            plugin.execute(unitTest, this.classes);
        }
    }
}

