/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.test;

import java.util.HashMap;
import java.util.Map;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 */
public class CompilerClassLoader extends ClassLoader {

  /** . */
  private final CompilerResult compilerResult;

  /** . */
  private final Map<String, Class<?>> cache;

  public CompilerClassLoader(ClassLoader classLoader, CompilerResult compilerResult) {
    super(classLoader);

    //
    this.compilerResult = compilerResult;
    this.cache = new HashMap<String, Class<?>>();
  }

  public CompilerClassLoader(CompilerResult compilerResult) {
    this.compilerResult = compilerResult;
    this.cache = new HashMap<String, Class<?>>();
  }

  @Override
  protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {

    //
    Class<?> clazz = cache.get(name);

    //
    if (clazz == null) {
      LocalFileObject cf = compilerResult.getClassFile(name);
      if (cf == null) {
        clazz = super.loadClass(name, resolve);
      } else {
        byte[] bytes = cf.getBytes();
        clazz = defineClass(name, bytes, 0, bytes.length, null);
        if (resolve) {
          resolveClass(clazz);
        }
        cache.put(name, clazz);
        return clazz;
      }
    }

    //
    return clazz;
  }
}
