/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.test;

import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 */
public class CompilerResult extends ForwardingJavaFileManager<StandardJavaFileManager> {

  /** . */
  private final Map<FileKey, LocalFileObject> files;

  public CompilerResult(StandardJavaFileManager standardJavaFileManager) {
    super(standardJavaFileManager);

    //
    this.files = new HashMap<FileKey, LocalFileObject>();
  }

  public LocalFileObject getClassFile(String name) {
    return files.get(new FileKey(JavaFileObject.Kind.CLASS, name));
  }

  @Override
  public JavaFileObject getJavaFileForOutput(
    Location location,
    String className,
    JavaFileObject.Kind kind,
    javax.tools.FileObject sibling) throws IOException {
    if ((kind == JavaFileObject.Kind.CLASS  || kind == JavaFileObject.Kind.SOURCE) && location.isOutputLocation()) {
      LocalFileObject fileObject = new LocalFileObject(className, kind);
      files.put(new FileKey(kind, className), fileObject);
      return fileObject;
    } else {
      throw new IOException("Cannot handle " + kind + " " + location);
    }
  }

  @Override
  public javax.tools.FileObject getFileForOutput(
    Location location,
    String packageName,
    String relativeName,
    javax.tools.FileObject sibling) throws IOException {
    throw new IOException();
  }
}
