/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.test;

import java.util.List;
import java.util.Set;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 */
public class ProcessorUnitTestPlugin extends UnitTestPlugin {

  @Override
  public void execute(ReflextUnitTest unitTest, Set<Class<?>> classes) throws Exception {

    //
    AnnotationProcessorTestRunner processor = new AnnotationProcessorTestRunner(unitTest);

    Compiler compiler = new Compiler(classes);

    //
    boolean ok = compiler.compile(processor);

    //
    List<Throwable> failures = processor.getFailures();
    if (failures.size() > 0) {
      AssertionError err = new AssertionError(compiler.getDiagnostic());
      err.initCause(failures.get(0));
      throw err;
    }

    //
    if (!ok) {
      AssertionError err = new AssertionError(compiler.getDiagnostic());
      err.initCause(new Exception("Compilation failed"));
      throw err;
    }
  }
}
