/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.test.conformance.arraytype;

import org.reflext.test.ReflectUnitTest;
import org.reflext.api.LiteralType;
import org.reflext.api.SimpleTypeInfo;
import org.reflext.api.ArrayTypeInfo;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.TypeVariableInfo;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class ArrayTypeUnitTest extends ReflectUnitTest {

  private void assertSimpleArray(String id, LiteralType literalType, boolean primitive, Class expectedClass) {
    ArrayTypeInfo typeInfo = (ArrayTypeInfo)getInfo(id);
    SimpleTypeInfo simpleType = (SimpleTypeInfo)typeInfo.getComponentType();
    assertEquals(literalType, simpleType.getLiteralType());
    assertEquals(primitive, simpleType.isPrimitive());
    assertEquals(expectedClass.getName(), simpleType.getName());
  }

  protected void execute() throws Exception {
    testSimpleTypes();
    testOtherTypes();
  }

  private void testSimpleTypes() throws Exception {
    assertSimpleArray("boolean", LiteralType.BOOLEAN, true, boolean.class);
    assertSimpleArray("byte", LiteralType.BYTE, true, byte.class);
    assertSimpleArray("short", LiteralType.SHORT, true, short.class);
    assertSimpleArray("int", LiteralType.INT, true, int.class);
    assertSimpleArray("long", LiteralType.LONG, true, long.class);
    assertSimpleArray("float", LiteralType.FLOAT, true, float.class);
    assertSimpleArray("double", LiteralType.DOUBLE, true, double.class);
    assertSimpleArray("Boolean", LiteralType.BOOLEAN, false, Boolean.class);
    assertSimpleArray("Byte", LiteralType.BYTE, false, Byte.class);
    assertSimpleArray("Short", LiteralType.SHORT, false, Short.class);
    assertSimpleArray("Integer", LiteralType.INT, false, Integer.class);
    assertSimpleArray("Long", LiteralType.LONG, false, Long.class);
    assertSimpleArray("Float", LiteralType.FLOAT, false, Float.class);
    assertSimpleArray("Double", LiteralType.DOUBLE, false, Double.class);
  }

  private void testOtherTypes() throws Exception {
    ArrayTypeInfo stringArrayTypeInfo = (ArrayTypeInfo)getInfo("string");
    ClassTypeInfo stringTypeInfo = (ClassTypeInfo)stringArrayTypeInfo.getComponentType();
    assertEquals(String.class.getName(), stringTypeInfo.getName());

    //
    ArrayTypeInfo typeVariableArrayTypeInfo = (ArrayTypeInfo)getInfo("x");
    TypeVariableInfo typeVariableInfo = (TypeVariableInfo)typeVariableArrayTypeInfo.getComponentType();
    assertEquals("X", typeVariableInfo.getName());

    //
    ArrayTypeInfo typeVariableArrayTypeInfo2 = (ArrayTypeInfo)getInfo("y");
    TypeVariableInfo typeVariableInfo2 = (TypeVariableInfo)typeVariableArrayTypeInfo2.getComponentType();
    assertEquals("Y", typeVariableInfo2.getName());
  }
}
