/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.test.conformance.methodtypevariable;

import org.reflext.test.ReflectUnitTest;
import org.reflext.api.TypeVariableInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.ParameterizedTypeInfo;

import java.util.List;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class MethodTypeVariableUnitTest extends ReflectUnitTest {

  protected void execute() throws Exception {
    TypeVariableInfo t1 = (TypeVariableInfo)getInfo("A_m1");
    MethodInfo genDecl = (MethodInfo)t1.getGenericDeclaration();
    List<TypeVariableInfo> typeParameters = genDecl.getTypeParameters();
    assertEquals(1, typeParameters.size());
    assertEquals(t1, typeParameters.get(0));

    //
    TypeVariableInfo t2 = (TypeVariableInfo)getInfo("A_m2");
    MethodInfo mi = (MethodInfo)t2.getGenericDeclaration();
    ParameterizedTypeInfo pti = (ParameterizedTypeInfo)mi.getParameterTypes().get(0);
    TypeVariableInfo t3 = (TypeVariableInfo)pti.getTypeArguments().get(0);
    assertNotSame(t2, t3);
    assertEquals(t2, t3);
  }
}
