/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.test.conformance.declaredmethods;

import java.util.List;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.VoidTypeInfo;
import org.reflext.test.ReflectUnitTest;

public class DeclaredMethodsUnitTest
extends ReflectUnitTest {
    protected void execute() throws Exception {
        this.testA();
        this.testB();
        this.testC();
        this.testD();
        this.testE();
        this.testF();
    }

    private void testA() {
        ClassTypeInfo ti = (ClassTypeInfo)this.getInfo("A");
        this.assertHasMethods(ti);
    }

    private void testB() {
        ClassTypeInfo ti = (ClassTypeInfo)this.getInfo("B");
        this.assertHasNoMethods(ti);
    }

    private void testC() {
        ClassTypeInfo ti = (ClassTypeInfo)this.getInfo("C");
        this.assertHasNoMethods(ti);
    }

    private void testD() {
        ClassTypeInfo ti = (ClassTypeInfo)this.getInfo("D");
        this.assertHasMethods(ti);
    }

    private void testE() {
        ClassTypeInfo ti = (ClassTypeInfo)this.getInfo("E");
        this.assertHasMethods(ti);
    }

    private void testF() {
        ClassTypeInfo ti = (ClassTypeInfo)this.getInfo("F");
        this.assertHasNoMethods(ti);
    }

    private void assertHasMethods(ClassTypeInfo cti) {
        List list = cti.getDeclaredMethods();
        DeclaredMethodsUnitTest.assertEquals((int)2, (int)list.size());
        MethodInfo m1 = (MethodInfo)list.get(0);
        DeclaredMethodsUnitTest.assertEquals((String)"m1", (String)m1.getName());
        TypeInfo m1rt = m1.getReturnType();
        DeclaredMethodsUnitTest.assertTrue((String)("Was expecting return type to be void instead of " + m1rt), (boolean)(m1rt instanceof VoidTypeInfo));
        MethodInfo m2 = (MethodInfo)list.get(1);
        DeclaredMethodsUnitTest.assertEquals((String)"m2", (String)m2.getName());
        DeclaredMethodsUnitTest.assertTrue((boolean)(m2.getReturnType() instanceof ClassTypeInfo));
        ClassTypeInfo m2rt = (ClassTypeInfo)m2.getReturnType();
        DeclaredMethodsUnitTest.assertEquals((String)String.class.getName(), (String)m2rt.getName());
    }

    private void assertHasNoMethods(ClassTypeInfo cti) {
        List list = cti.getDeclaredMethods();
        DeclaredMethodsUnitTest.assertEquals((int)0, (int)list.size());
    }
}

