/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.test.conformance.annotation;

import org.reflext.api.ClassTypeInfo;
import org.reflext.api.annotation.AnnotationInfo;
import org.reflext.api.annotation.AnnotationParameterInfo;
import org.reflext.api.annotation.AnnotationParameterType;
import org.reflext.api.annotation.AnnotationType;
import org.reflext.test.ReflectUnitTest;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class DeclaredAnnotationUnitTest extends ReflectUnitTest {

  protected void execute() throws Exception {


    ClassTypeInfo a = (ClassTypeInfo)getTypeInfo("a");
    ClassTypeInfo b = (ClassTypeInfo)getTypeInfo("b");

    assertNotNull(a);
    assertNotNull(b);

    AnnotationInfo ai = b.getDeclaredAnnotation(AnnotationType.get(a));

    //
    assertNotNull(ai);
    assertEquals(a, ai.getType());

    //
    AnnotationParameterInfo stringParam = ai.getParameter("_String");
    assertNotNull(stringParam);
    assertEquals("_String", stringParam.getName());
    assertEquals("bilto", stringParam.getValue());
    assertEquals(Arrays.asList("bilto"), stringParam.getValues());
    assertEquals(AnnotationParameterType.STRING , stringParam.getType());
    assertEquals(false, stringParam.isMultiValued());

    //
    AnnotationParameterInfo classParam = ai.getParameter("_Class");
    assertEquals("_Class", classParam.getName());
    assertEquals(AnnotationParameterType.CLASS, classParam.getType());
    assertTrue(classParam.getValue() instanceof ClassTypeInfo);
    assertEquals(String.class.getName(), ((ClassTypeInfo)classParam.getValue()).getName());
    assertEquals(false, classParam.isMultiValued());

    //
    AnnotationParameterInfo doubleParam = ai.getParameter("_double");
    assertEquals("_double", doubleParam.getName());
    assertEquals(AnnotationParameterType.DOUBLE, doubleParam.getType());
    assertEquals(1D, doubleParam.getValue());
    assertEquals(false, doubleParam.isMultiValued());

    //
    AnnotationParameterInfo intParam = ai.getParameter("_int");
    assertEquals("_int", intParam.getName());
    assertEquals(AnnotationParameterType.INTEGER, intParam.getType());
    assertEquals(3, intParam.getValue());
    assertEquals(false, intParam.isMultiValued());

    //
    AnnotationParameterInfo booleanParam = ai.getParameter("_boolean");
    assertEquals("_boolean", booleanParam.getName());
    assertEquals(AnnotationParameterType.BOOLEAN, booleanParam.getType());
    assertEquals(true, booleanParam.getValue());
    assertEquals(false, booleanParam.isMultiValued());

    //
    AnnotationParameterInfo enumParam = ai.getParameter("_enum");
    assertEquals("_enum", enumParam.getName());
    assertEquals(AnnotationParameterType.ENUM, enumParam.getType());
    assertEquals(RetentionPolicy.SOURCE.name(), enumParam.getValue());
    assertEquals(false, enumParam.isMultiValued());

    //
    AnnotationParameterInfo annotationParam = ai.getParameter("_annotation");
    assertEquals("_annotation", annotationParam.getName());
    assertEquals(AnnotationParameterType.ANNOTATION, annotationParam.getType());
    AnnotationInfo annotationParamValue = (AnnotationInfo)annotationParam.getValue();
    assertNotNull(annotationParamValue);
    assertEquals(Retention.class.getName(), annotationParamValue.getType().getName());
    assertEquals(AnnotationParameterType.ENUM, annotationParamValue.getParameter("value").getType());
    assertEquals(RetentionPolicy.SOURCE.name(), annotationParamValue.getParameter("value").getValue());
    assertEquals(false, annotationParam.isMultiValued());

    //
    AnnotationParameterInfo stringsParam = ai.getParameter("_Strings");
    assertNotNull(stringsParam);
    assertEquals("_Strings", stringsParam.getName());
    assertEquals("a", stringsParam.getValue());
    assertEquals(Arrays.asList("a","b"), stringsParam.getValues());
    assertEquals(AnnotationParameterType.STRING , stringsParam.getType());
    assertEquals(true, stringsParam.isMultiValued());

    //
    AnnotationParameterInfo classExtendsNumberParam = ai.getParameter("_ClassExtendsNumber");
    assertNotNull(classExtendsNumberParam);
    assertEquals("_ClassExtendsNumber", classExtendsNumberParam.getName());
    assertTrue(classExtendsNumberParam.getValue() instanceof ClassTypeInfo);
    assertEquals(Integer.class.getName(), ((ClassTypeInfo)classExtendsNumberParam.getValue()).getName());
    assertEquals(AnnotationParameterType.CLASS , classExtendsNumberParam.getType());
    assertEquals(false, classExtendsNumberParam.isMultiValued());

    //
    AnnotationParameterInfo classSuperNumberParam = ai.getParameter("_ClassSuperNumber");
    assertNotNull(classSuperNumberParam);
    assertEquals("_ClassSuperNumber", classSuperNumberParam.getName());
    assertTrue(classSuperNumberParam.getValue() instanceof ClassTypeInfo);
    assertEquals(Object.class.getName(), ((ClassTypeInfo)classSuperNumberParam.getValue()).getName());
    assertEquals(AnnotationParameterType.CLASS , classSuperNumberParam.getType());
    assertEquals(false, classSuperNumberParam.isMultiValued());

    //
    AnnotationParameterInfo unknownClassParam = ai.getParameter("_UnknownClass");
    assertNotNull(unknownClassParam);
    assertEquals("_UnknownClass", unknownClassParam.getName());
    assertTrue(unknownClassParam.getValue() instanceof ClassTypeInfo);
    assertEquals(Boolean.class.getName(), ((ClassTypeInfo)unknownClassParam.getValue()).getName());
    assertEquals(AnnotationParameterType.CLASS , unknownClassParam.getType());
    assertEquals(false, unknownClassParam.isMultiValued());
  }
}