/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.test.conformance.arraytype;

import org.reflext.api.ArrayTypeInfo;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.LiteralType;
import org.reflext.api.SimpleTypeInfo;
import org.reflext.api.TypeVariableInfo;
import org.reflext.test.ReflectUnitTest;

public class ArrayTypeUnitTest
extends ReflectUnitTest {
    private void assertSimpleArray(String id, LiteralType literalType, boolean primitive, Class expectedClass) {
        ArrayTypeInfo typeInfo = (ArrayTypeInfo)this.getTypeInfo(id);
        SimpleTypeInfo simpleType = (SimpleTypeInfo)typeInfo.getComponentType();
        ArrayTypeUnitTest.assertEquals((Object)literalType, (Object)simpleType.getLiteralType());
        ArrayTypeUnitTest.assertEquals((boolean)primitive, (boolean)simpleType.isPrimitive());
        ArrayTypeUnitTest.assertEquals((String)expectedClass.getName(), (String)simpleType.getName());
    }

    protected void execute() throws Exception {
        this.testSimpleTypes();
        this.testOtherTypes();
    }

    private void testSimpleTypes() throws Exception {
        this.assertSimpleArray("boolean", LiteralType.BOOLEAN, true, Boolean.TYPE);
        this.assertSimpleArray("byte", LiteralType.BYTE, true, Byte.TYPE);
        this.assertSimpleArray("short", LiteralType.SHORT, true, Short.TYPE);
        this.assertSimpleArray("int", LiteralType.INT, true, Integer.TYPE);
        this.assertSimpleArray("long", LiteralType.LONG, true, Long.TYPE);
        this.assertSimpleArray("float", LiteralType.FLOAT, true, Float.TYPE);
        this.assertSimpleArray("double", LiteralType.DOUBLE, true, Double.TYPE);
        this.assertSimpleArray("Boolean", LiteralType.BOOLEAN, false, Boolean.class);
        this.assertSimpleArray("Byte", LiteralType.BYTE, false, Byte.class);
        this.assertSimpleArray("Short", LiteralType.SHORT, false, Short.class);
        this.assertSimpleArray("Integer", LiteralType.INT, false, Integer.class);
        this.assertSimpleArray("Long", LiteralType.LONG, false, Long.class);
        this.assertSimpleArray("Float", LiteralType.FLOAT, false, Float.class);
        this.assertSimpleArray("Double", LiteralType.DOUBLE, false, Double.class);
    }

    private void testOtherTypes() throws Exception {
        ArrayTypeInfo stringArrayTypeInfo = (ArrayTypeInfo)this.getTypeInfo("string");
        ClassTypeInfo stringTypeInfo = (ClassTypeInfo)stringArrayTypeInfo.getComponentType();
        ArrayTypeUnitTest.assertEquals((String)String.class.getName(), (String)stringTypeInfo.getName());
        ArrayTypeInfo typeVariableArrayTypeInfo = (ArrayTypeInfo)this.getTypeInfo("x");
        TypeVariableInfo typeVariableInfo = (TypeVariableInfo)typeVariableArrayTypeInfo.getComponentType();
        ArrayTypeUnitTest.assertEquals((String)"X", (String)typeVariableInfo.getVariableName());
        ArrayTypeInfo typeVariableArrayTypeInfo2 = (ArrayTypeInfo)this.getTypeInfo("y");
        TypeVariableInfo typeVariableInfo2 = (TypeVariableInfo)typeVariableArrayTypeInfo2.getComponentType();
        ArrayTypeUnitTest.assertEquals((String)"Y", (String)typeVariableInfo2.getVariableName());
    }
}

