/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.test.conformance.wildcardtype;

import org.reflext.api.ClassTypeInfo;
import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.WildcardTypeInfo;
import org.reflext.test.ReflectUnitTest;

public class WildcardUnitTest
extends ReflectUnitTest {
    private WildcardTypeInfo getWildcardType(String typeId) {
        ParameterizedTypeInfo typeInfo = (ParameterizedTypeInfo)this.getTypeInfo(typeId);
        return (WildcardTypeInfo)typeInfo.getTypeArguments().get(0);
    }

    private void assertBlah(WildcardTypeInfo wildcard) {
        if (!wildcard.getUpperBounds().isEmpty()) {
            if (wildcard.getUpperBounds().size() == 1) {
                ClassTypeInfo cti = (ClassTypeInfo)wildcard.getUpperBounds().get(0);
                WildcardUnitTest.assertEquals((String)Object.class.getName(), (String)cti.getName());
            } else {
                WildcardUnitTest.fail();
            }
        }
    }

    protected void execute() throws Exception {
        WildcardTypeInfo m1 = this.getWildcardType("m1");
        this.assertBlah(m1);
        WildcardUnitTest.assertTrue((boolean)m1.getLowerBounds().isEmpty());
        WildcardTypeInfo m2 = this.getWildcardType("m2");
        WildcardUnitTest.assertEquals((int)1, (int)m2.getUpperBounds().size());
        WildcardUnitTest.assertEquals((int)0, (int)m2.getLowerBounds().size());
        WildcardTypeInfo m3 = this.getWildcardType("m3");
        this.assertBlah(m3);
        WildcardUnitTest.assertEquals((int)1, (int)m3.getLowerBounds().size());
        WildcardUnitTest.assertEquals((String)Object.class.getName(), (String)((ClassTypeInfo)m3.getLowerBounds().get(0)).getName());
        WildcardTypeInfo m4 = this.getWildcardType("m4");
        WildcardUnitTest.assertEquals((int)1, (int)m4.getUpperBounds().size());
        WildcardUnitTest.assertEquals((String)Number.class.getName(), (String)((ClassTypeInfo)m4.getUpperBounds().get(0)).getName());
        WildcardUnitTest.assertEquals((int)0, (int)m4.getLowerBounds().size());
        WildcardTypeInfo m5 = this.getWildcardType("m5");
        this.assertBlah(m5);
        WildcardUnitTest.assertEquals((int)1, (int)m5.getLowerBounds().size());
        WildcardUnitTest.assertEquals((String)Number.class.getName(), (String)((ClassTypeInfo)m5.getLowerBounds().get(0)).getName());
    }
}

