/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.reflext.test.conformance.assignable.classtype.classtype;

import org.reflext.test.ReflectUnitTest;
import org.reflext.api.ClassTypeInfo;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class AssignableUnitTest extends ReflectUnitTest {

  protected void execute() throws Exception {
    ClassTypeInfo objectTI = (ClassTypeInfo)((ClassTypeInfo)getTypeInfo("C")).getSuperType();
    assertEquals("java.lang.Object", objectTI.getName());

    //
    compare("A", Comparison.SAME, "A");
    compare("A", Comparison.FROM, "B");
    compare("A", Comparison.FROM, "C");
    compare("A", Comparison.FROM, "D");
    compare("B", Comparison.SAME, "B");
    compare("B", Comparison.FROM, "C");
    compare("B", Comparison.FROM, "D");
    compare("C", Comparison.SAME, "C");
    compare("C", Comparison.FROM, "D");
    compare("D", Comparison.SAME, "D");

    //
    assertTrue(objectTI.isAssignableFrom((ClassTypeInfo)getTypeInfo("A")));
    assertTrue(objectTI.isAssignableFrom((ClassTypeInfo)getTypeInfo("C")));
  }
}