/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.reflext.test.usecases.selfbounded;

import org.reflext.api.ClassTypeInfo;
import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.TypeVariableInfo;
import org.reflext.test.ResolverUnitTest;

import java.util.List;

/**
 * @author <a href="mailto:julien.viet@exoplatform.com">Julien Viet</a>
 * @version $Revision$
 */
public class SelfBoundedUnitTest extends ResolverUnitTest {

  @Override
  protected void execute() throws Exception {
    ClassTypeInfo a = (ClassTypeInfo)getTypeInfo("A");
    List<TypeVariableInfo> vars = a.getTypeParameters();
    assertEquals(1, vars.size());
    TypeVariableInfo t = vars.get(0);
    assertEquals("T", t.getName());
    assertEquals(1, t.getBounds().size());
    ParameterizedTypeInfo p = (ParameterizedTypeInfo)t.getBounds().get(0);
    assertEquals(1, p.getTypeArguments().size());
    assertEquals(t, p.getTypeArguments().get(0));
    assertEquals(a, p.getRawType());

    //
    ClassTypeInfo b = (ClassTypeInfo)getTypeInfo("B");
    ParameterizedTypeInfo p2 = (ParameterizedTypeInfo)b.getSuperType();
    assertEquals(1, p2.getTypeArguments().size());
    assertEquals(b, p2.getTypeArguments().get(0));
    assertEquals(a, p2.getRawType());
  }
}
