/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.test.conformance.field;

import java.util.HashMap;
import org.reflext.api.AccessScope;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.FieldInfo;
import org.reflext.api.annotation.AnnotationType;
import org.reflext.test.ReflextUnitTest;

public class FieldUnitTest
extends ReflextUnitTest {
    protected void execute() throws Exception {
        this.testNames();
        this.testAccessMode();
        this.testType();
        this.testModifiers();
        this.testAnnotations();
    }

    public void testAnnotations() throws Exception {
        ClassTypeInfo ecti = (ClassTypeInfo)this.getTypeInfo("E");
        FieldInfo a = ecti.getDeclaredField("a");
        Deprecated deprecated = (Deprecated)a.getDeclaredAnnotation(AnnotationType.get(Deprecated.class));
        FieldUnitTest.assertNotNull((Object)deprecated);
    }

    public void testModifiers() throws Exception {
        ClassTypeInfo dcti = (ClassTypeInfo)this.getTypeInfo("D");
        FieldInfo a = dcti.getDeclaredField("a");
        FieldUnitTest.assertEquals((boolean)false, (boolean)a.isFinal());
        FieldUnitTest.assertEquals((boolean)false, (boolean)a.isStatic());
        FieldInfo b = dcti.getDeclaredField("b");
        FieldUnitTest.assertEquals((boolean)true, (boolean)b.isFinal());
        FieldUnitTest.assertEquals((boolean)false, (boolean)b.isStatic());
        FieldInfo c = dcti.getDeclaredField("c");
        FieldUnitTest.assertEquals((boolean)true, (boolean)c.isFinal());
        FieldUnitTest.assertEquals((boolean)true, (boolean)c.isStatic());
        FieldInfo d = dcti.getDeclaredField("d");
        FieldUnitTest.assertEquals((boolean)false, (boolean)d.isFinal());
        FieldUnitTest.assertEquals((boolean)true, (boolean)d.isStatic());
    }

    public void testNames() throws Exception {
        ClassTypeInfo ccti = (ClassTypeInfo)this.getTypeInfo("C");
        HashMap<String, FieldInfo> fields = new HashMap<String, FieldInfo>();
        for (FieldInfo fi : ccti.getDeclaredFields()) {
            fields.put(fi.getName(), fi);
        }
        FieldUnitTest.assertEquals((int)2, (int)fields.size());
        FieldUnitTest.assertEquals((String)"a", (String)((FieldInfo)fields.get("a")).getName());
        FieldUnitTest.assertEquals((String)"b", (String)((FieldInfo)fields.get("b")).getName());
    }

    public void testType() {
        ClassTypeInfo acti = (ClassTypeInfo)this.getTypeInfo("A");
        ClassTypeInfo bcti = (ClassTypeInfo)this.getTypeInfo("B");
        FieldUnitTest.assertEquals((Object)acti, (Object)bcti.getDeclaredField("a").getType());
    }

    public void testAccessMode() {
        ClassTypeInfo cti = (ClassTypeInfo)this.getTypeInfo("A");
        FieldInfo a = cti.getDeclaredField("a");
        FieldUnitTest.assertEquals((Object)AccessScope.PUBLIC, (Object)a.getAccess());
        FieldInfo b = cti.getDeclaredField("b");
        FieldUnitTest.assertEquals((Object)AccessScope.PRIVATE, (Object)b.getAccess());
        FieldInfo c = cti.getDeclaredField("c");
        FieldUnitTest.assertEquals((Object)AccessScope.PROTECTED, (Object)c.getAccess());
        FieldInfo d = cti.getDeclaredField("d");
        FieldUnitTest.assertEquals((Object)AccessScope.PACKAGE_PROTECTED, (Object)d.getAccess());
    }
}

