/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.atom.internal;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.engine.util.DateUtils;
import org.restlet.ext.atom.Category;
import org.restlet.ext.atom.Content;
import org.restlet.ext.atom.Entry;
import org.restlet.ext.atom.EntryReader;
import org.restlet.ext.atom.Link;
import org.restlet.ext.atom.Person;
import org.restlet.ext.atom.Relation;
import org.restlet.ext.atom.Text;
import org.restlet.ext.xml.XmlWriter;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class EntryContentReader
extends EntryReader {
    private StringBuilder contentBuffer;
    private MediaType contentType;
    private int contentDepth = -1;
    private Category currentCategory;
    private Content currentContent;
    private XmlWriter currentContentWriter;
    private Date currentDate;
    private Entry currentEntry;
    private Link currentLink;
    private Person currentPerson;
    private Text currentText;
    private Map<String, String> prefixMappings;
    private State state = State.NONE;

    public EntryContentReader(Entry entry) {
        this(entry, null);
    }

    public EntryContentReader(Entry entry, EntryReader extraEntryHandler) {
        super(extraEntryHandler);
        this.currentEntry = entry;
        this.currentText = null;
        this.currentDate = null;
        this.currentLink = null;
        this.currentPerson = null;
        this.contentBuffer = null;
        this.currentCategory = null;
        this.currentContent = null;
        this.prefixMappings = new ConcurrentHashMap<String, String>();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.contentDepth >= 0) {
            if (this.currentContentWriter != null) {
                this.currentContentWriter.characters(ch, start, length);
            }
        } else {
            this.contentBuffer.append(ch, start, length);
        }
        super.characters(ch, start, length);
    }

    public void endDocument() throws SAXException {
        this.state = State.NONE;
        this.contentBuffer = null;
        super.endDocument();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.currentText != null) {
            this.currentText.setContent(this.contentBuffer.toString());
        }
        if (this.currentDate != null) {
            String formattedDate = this.contentBuffer.toString();
            Date parsedDate = DateUtils.parse((String)formattedDate.trim(), (List)DateUtils.FORMAT_RFC_3339);
            if (parsedDate != null) {
                this.currentDate.setTime(parsedDate.getTime());
            } else {
                this.currentDate = null;
            }
        }
        if (this.contentDepth > 0) {
            if (this.currentContentWriter != null) {
                this.currentContentWriter.endElement(uri, localName, qName);
            }
            --this.contentDepth;
        } else if (uri.equalsIgnoreCase("http://www.w3.org/2005/Atom")) {
            String content;
            if (localName.equals("feed")) {
                this.state = State.NONE;
            } else if (localName.equals("title")) {
                if (this.state == State.FEED_ENTRY_TITLE) {
                    this.currentEntry.setTitle(this.currentText);
                    this.state = State.FEED_ENTRY;
                } else if (this.state == State.FEED_ENTRY_SOURCE_TITLE) {
                    this.currentEntry.getSource().setTitle(this.currentText);
                    this.state = State.FEED_ENTRY_SOURCE;
                }
            } else if (localName.equals("updated")) {
                if (this.state == State.FEED_ENTRY_UPDATED) {
                    this.currentEntry.setUpdated(this.currentDate);
                    this.state = State.FEED_ENTRY;
                } else if (this.state == State.FEED_ENTRY_SOURCE_UPDATED) {
                    this.currentEntry.getSource().setUpdated(this.currentDate);
                    this.state = State.FEED_ENTRY_SOURCE;
                }
            } else if (localName.equals("published")) {
                if (this.state == State.FEED_ENTRY_PUBLISHED) {
                    this.currentEntry.setPublished(this.currentDate);
                    this.state = State.FEED_ENTRY;
                }
            } else if (localName.equals("author")) {
                if (this.state == State.FEED_ENTRY_AUTHOR) {
                    this.currentEntry.getAuthors().add(this.currentPerson);
                    this.state = State.FEED_ENTRY;
                } else if (this.state == State.FEED_ENTRY_SOURCE_AUTHOR) {
                    this.currentEntry.getSource().getAuthors().add(this.currentPerson);
                    this.state = State.FEED_ENTRY_SOURCE;
                }
            } else if (localName.equals("name")) {
                this.currentPerson.setName(this.contentBuffer.toString());
                if (this.state == State.FEED_ENTRY_AUTHOR_NAME) {
                    this.state = State.FEED_ENTRY_AUTHOR;
                } else if (this.state == State.FEED_ENTRY_SOURCE_AUTHOR_NAME) {
                    this.state = State.FEED_ENTRY_SOURCE_AUTHOR;
                }
            } else if (localName.equals("id")) {
                if (this.state == State.FEED_ENTRY_ID) {
                    this.currentEntry.setId(this.contentBuffer.toString());
                    this.state = State.FEED_ENTRY;
                } else if (this.state == State.FEED_ENTRY_SOURCE_ID) {
                    this.currentEntry.getSource().setId(this.contentBuffer.toString());
                    this.state = State.FEED_ENTRY_SOURCE;
                }
            } else if (localName.equals("link")) {
                if (this.state == State.FEED_ENTRY_LINK) {
                    this.currentEntry.getLinks().add(this.currentLink);
                    this.state = State.FEED_ENTRY;
                } else if (this.state == State.FEED_ENTRY_SOURCE_LINK) {
                    this.currentEntry.getSource().getLinks().add(this.currentLink);
                    this.state = State.FEED_ENTRY_SOURCE;
                }
                if (this.currentContentWriter != null) {
                    content = this.currentContentWriter.getWriter().toString().trim();
                    this.contentDepth = -1;
                    if ("".equals(content)) {
                        this.currentLink.setContent(null);
                    } else if (this.currentLink.getType() != null) {
                        this.currentContent.setInlineContent((Representation)new StringRepresentation((CharSequence)content, this.currentLink.getType()));
                    } else {
                        this.currentContent.setInlineContent((Representation)new StringRepresentation((CharSequence)content, this.contentType));
                    }
                    this.currentContentWriter = null;
                }
                this.endLink(this.currentLink);
            } else if (localName.equalsIgnoreCase("entry")) {
                this.state = State.NONE;
                this.endEntry(this.currentEntry);
            } else if (localName.equals("category")) {
                if (this.state == State.FEED_ENTRY_CATEGORY) {
                    this.currentEntry.getCategories().add(this.currentCategory);
                    this.state = State.FEED_ENTRY;
                } else if (this.state == State.FEED_ENTRY_SOURCE_CATEGORY) {
                    this.currentEntry.getSource().getCategories().add(this.currentCategory);
                    this.state = State.FEED_ENTRY_SOURCE;
                }
            } else if (localName.equalsIgnoreCase("content")) {
                if (this.state == State.FEED_ENTRY_CONTENT) {
                    if (!this.currentEntry.getContent().isExternal()) {
                        content = this.currentContentWriter.getWriter().toString().trim();
                        this.contentDepth = -1;
                        if ("".equals(content)) {
                            this.currentEntry.setContent(null);
                        } else {
                            this.currentContent.setInlineContent((Representation)new StringRepresentation((CharSequence)content));
                        }
                    }
                    this.state = State.FEED_ENTRY;
                }
                this.currentContentWriter = null;
                this.endContent(this.currentContent);
            }
        }
        this.currentText = null;
        this.currentDate = null;
        super.endElement(uri, localName, qName);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.prefixMappings.remove(prefix);
        super.endPrefixMapping(prefix);
    }

    private MediaType getMediaType(String type) {
        MediaType result = null;
        if (type != null) {
            result = type.equals("text") ? MediaType.TEXT_PLAIN : (type.equals("html") ? MediaType.TEXT_HTML : (type.equals("xhtml") ? MediaType.APPLICATION_XHTML : new MediaType(type)));
        }
        return result;
    }

    private void initiateInlineMixedContent() {
        this.contentDepth = 0;
        StringWriter sw = new StringWriter();
        this.currentContentWriter = new XmlWriter((Writer)sw);
        for (String prefix : this.prefixMappings.keySet()) {
            this.currentContentWriter.forceNSDecl(this.prefixMappings.get(prefix), prefix);
        }
    }

    public void startDocument() throws SAXException {
        this.contentBuffer = new StringBuilder();
        super.startDocument();
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        this.contentBuffer.delete(0, this.contentBuffer.length() + 1);
        if (this.contentDepth >= 0) {
            if (this.currentContentWriter != null) {
                this.currentContentWriter.startElement(uri, localName, qName, attrs);
            }
            ++this.contentDepth;
        } else if (uri.equalsIgnoreCase("http://www.w3.org/2005/Atom")) {
            if (localName.equals("title")) {
                this.startTextElement(attrs);
                if (this.state == State.FEED_ENTRY) {
                    this.state = State.FEED_ENTRY_TITLE;
                } else if (this.state == State.FEED_ENTRY_SOURCE) {
                    this.state = State.FEED_ENTRY_SOURCE_TITLE;
                }
            } else if (localName.equals("updated")) {
                this.currentDate = new Date();
                if (this.state == State.FEED_ENTRY) {
                    this.state = State.FEED_ENTRY_UPDATED;
                } else if (this.state == State.FEED_ENTRY_SOURCE) {
                    this.state = State.FEED_ENTRY_SOURCE_UPDATED;
                }
            } else if (localName.equals("published")) {
                this.currentDate = new Date();
                if (this.state == State.FEED_ENTRY) {
                    this.state = State.FEED_ENTRY_PUBLISHED;
                }
            } else if (localName.equals("author")) {
                this.currentPerson = new Person();
                if (this.state == State.FEED_ENTRY) {
                    this.state = State.FEED_ENTRY_AUTHOR;
                } else if (this.state == State.FEED_ENTRY_SOURCE) {
                    this.state = State.FEED_ENTRY_SOURCE_AUTHOR;
                }
            } else if (localName.equals("name")) {
                if (this.state == State.FEED_ENTRY_AUTHOR) {
                    this.state = State.FEED_ENTRY_AUTHOR_NAME;
                } else if (this.state == State.FEED_ENTRY_SOURCE_AUTHOR) {
                    this.state = State.FEED_ENTRY_SOURCE_AUTHOR_NAME;
                }
            } else if (localName.equals("id")) {
                if (this.state == State.FEED_ENTRY) {
                    this.state = State.FEED_ENTRY_ID;
                } else if (this.state == State.FEED_ENTRY_SOURCE) {
                    this.state = State.FEED_ENTRY_SOURCE_ID;
                }
            } else if (localName.equals("link")) {
                this.currentLink = new Link();
                this.currentLink.setHref(new Reference(attrs.getValue("", "href")));
                this.currentLink.setRel(Relation.valueOf(attrs.getValue("", "rel")));
                String type = attrs.getValue("", "type");
                if (type != null && type.length() > 0) {
                    this.currentLink.setType(new MediaType(type));
                }
                this.currentLink.setHrefLang(new Language(attrs.getValue("", "hreflang")));
                this.currentLink.setTitle(attrs.getValue("", "title"));
                String attr = attrs.getValue("", "length");
                this.currentLink.setLength(attr == null ? -1L : Long.parseLong(attr));
                if (this.state == State.FEED_ENTRY) {
                    this.state = State.FEED_ENTRY_LINK;
                } else if (this.state == State.FEED_ENTRY_SOURCE) {
                    this.state = State.FEED_ENTRY_SOURCE_LINK;
                }
                this.currentContent = new Content();
                this.initiateInlineMixedContent();
                this.currentLink.setContent(this.currentContent);
                this.startLink(this.currentLink);
            } else if (localName.equalsIgnoreCase("entry")) {
                this.state = State.FEED_ENTRY;
                this.startEntry(this.currentEntry);
            } else if (localName.equals("category")) {
                this.currentCategory = new Category();
                this.currentCategory.setTerm(attrs.getValue("", "term"));
                this.currentCategory.setScheme(new Reference(attrs.getValue("", "scheme")));
                this.currentCategory.setLabel(attrs.getValue("", "label"));
                if (this.state == State.FEED_ENTRY) {
                    this.state = State.FEED_ENTRY_CATEGORY;
                } else if (this.state == State.FEED_ENTRY_SOURCE) {
                    this.state = State.FEED_ENTRY_SOURCE_CATEGORY;
                }
            } else if (localName.equalsIgnoreCase("content")) {
                if (this.state == State.FEED_ENTRY) {
                    this.contentType = this.getMediaType(attrs.getValue("", "type"));
                    String srcAttr = attrs.getValue("", "src");
                    this.currentContent = new Content();
                    if (srcAttr == null) {
                        this.initiateInlineMixedContent();
                    } else {
                        this.currentContent.setExternalRef(new Reference(srcAttr));
                        this.currentContent.setExternalType(this.contentType);
                    }
                    this.currentEntry.setContent(this.currentContent);
                    this.state = State.FEED_ENTRY_CONTENT;
                }
                this.startContent(this.currentContent);
            }
        }
        super.startElement(uri, localName, qName, attrs);
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.prefixMappings.put(prefix, uri);
        super.startPrefixMapping(prefix, uri);
    }

    public void startTextElement(Attributes attrs) {
        this.currentText = new Text(this.getMediaType(attrs.getValue("", "type")));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        FEED_ENTRY,
        FEED_ENTRY_AUTHOR,
        FEED_ENTRY_AUTHOR_EMAIL,
        FEED_ENTRY_AUTHOR_NAME,
        FEED_ENTRY_AUTHOR_URI,
        FEED_ENTRY_CATEGORY,
        FEED_ENTRY_CONTENT,
        FEED_ENTRY_CONTRIBUTOR,
        FEED_ENTRY_ID,
        FEED_ENTRY_LINK,
        FEED_ENTRY_PUBLISHED,
        FEED_ENTRY_RIGHTS,
        FEED_ENTRY_SOURCE,
        FEED_ENTRY_SOURCE_AUTHOR,
        FEED_ENTRY_SOURCE_AUTHOR_EMAIL,
        FEED_ENTRY_SOURCE_AUTHOR_NAME,
        FEED_ENTRY_SOURCE_AUTHOR_URI,
        FEED_ENTRY_SOURCE_CATEGORY,
        FEED_ENTRY_SOURCE_CONTRIBUTOR,
        FEED_ENTRY_SOURCE_GENERATOR,
        FEED_ENTRY_SOURCE_ICON,
        FEED_ENTRY_SOURCE_ID,
        FEED_ENTRY_SOURCE_LINK,
        FEED_ENTRY_SOURCE_LOGO,
        FEED_ENTRY_SOURCE_RIGHTS,
        FEED_ENTRY_SOURCE_SUBTITLE,
        FEED_ENTRY_SOURCE_TITLE,
        FEED_ENTRY_SOURCE_UPDATED,
        FEED_ENTRY_SUMMARY,
        FEED_ENTRY_TITLE,
        FEED_ENTRY_UPDATED,
        NONE;

    }
}

