/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.rdf.internal.ntriples;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import org.restlet.data.Reference;
import org.restlet.engine.io.IoUtils;
import org.restlet.ext.rdf.GraphHandler;
import org.restlet.ext.rdf.Link;
import org.restlet.ext.rdf.Literal;
import org.restlet.ext.rdf.internal.RdfReader;
import org.restlet.representation.Representation;

public class RdfNTriplesReader
extends RdfReader {
    private BufferedReader br;
    private final char[] buffer = new char[8194];
    private final int BUFFER_SIZE = 4096;
    public final int EOF = 0;
    private int scoutIndex;
    private int startTokenIndex;

    public RdfNTriplesReader(Representation rdfRepresentation, GraphHandler graphHandler) throws IOException {
        super(rdfRepresentation, graphHandler);
        this.buffer[8193] = '\u0000';
        this.buffer[4096] = '\u0000';
        this.scoutIndex = 8192;
        this.startTokenIndex = 0;
        this.br = new BufferedReader(this.getRdfRepresentation().getReader(), IoUtils.BUFFER_SIZE);
    }

    protected void consumeStatement() throws IOException {
        int c = this.getChar();
        while (!this.isEndOfFile(c) && c != 46) {
            c = this.step();
        }
        if (this.getChar() == '.') {
            this.step();
        }
        this.discard();
    }

    protected void consumeWhiteSpaces() throws IOException {
        while (this.isWhiteSpace(this.getChar())) {
            this.step();
        }
        this.discard();
    }

    protected void discard() {
        this.startTokenIndex = this.scoutIndex;
    }

    protected char getChar() {
        return this.buffer[this.scoutIndex];
    }

    protected String getCurrentToken() {
        StringBuilder builder = new StringBuilder();
        if (this.startTokenIndex <= this.scoutIndex) {
            if (this.scoutIndex <= 4096) {
                for (int i = this.startTokenIndex; i < this.scoutIndex; ++i) {
                    builder.append(this.buffer[i]);
                }
            } else {
                int i;
                for (i = this.startTokenIndex; i < 4096; ++i) {
                    builder.append(this.buffer[i]);
                }
                for (i = 4097; i < this.scoutIndex; ++i) {
                    builder.append(this.buffer[i]);
                }
            }
        } else if (this.startTokenIndex <= 4096) {
            int i;
            for (i = this.startTokenIndex; i < 4096; ++i) {
                builder.append(this.buffer[i]);
            }
            for (i = 4097; i < 8193; ++i) {
                builder.append(this.buffer[i]);
            }
            for (i = 0; i < this.scoutIndex; ++i) {
                builder.append(this.buffer[i]);
            }
        } else {
            int i;
            for (i = this.startTokenIndex; i < 8193; ++i) {
                builder.append(this.buffer[i]);
            }
            for (i = 0; i < this.scoutIndex; ++i) {
                builder.append(this.buffer[i]);
            }
        }
        this.startTokenIndex = this.scoutIndex;
        return builder.toString();
    }

    public String getParsingMessage() {
        return this.getParsingMessage(this.buffer, this.startTokenIndex, this.scoutIndex);
    }

    protected String getParsingMessage(char[] buffer, int startTokenIndex, int scoutIndex) {
        StringBuilder sb = new StringBuilder("Parsing data [");
        sb.append(startTokenIndex);
        sb.append(",");
        sb.append(scoutIndex);
        sb.append("] near ");
        if (startTokenIndex < 25) {
            sb.append(buffer, buffer.length - 30, 28);
            sb.append(buffer, 0, 25);
        } else if (startTokenIndex > buffer.length - 25) {
            sb.append(buffer, buffer.length - 30, 28);
            sb.append(buffer, 0, 20);
        } else {
            sb.append(buffer, startTokenIndex - 25, 50);
        }
        return sb.toString();
    }

    protected boolean isAlphaNum(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57;
    }

    protected boolean isDelimiter(int c) {
        return this.isWhiteSpace(c) || c == 34 || c == 46;
    }

    protected boolean isEndOfFile(int c) {
        return c == 0;
    }

    protected boolean isWhiteSpace(int c) {
        return c == 32 || c == 10 || c == 13 || c == 9;
    }

    public void parse() throws IOException {
        this.step();
        do {
            this.consumeWhiteSpaces();
            switch (this.getChar()) {
                case '#': {
                    this.parseComment();
                    break;
                }
                case '.': {
                    this.step();
                    break;
                }
                default: {
                    this.parseStatement();
                }
            }
        } while (!this.isEndOfFile(this.getChar()));
    }

    protected void parseComment() throws IOException {
        int c;
        do {
            c = this.step();
        } while (!this.isEndOfFile(this.getChar()) && c != 10 && c != 13);
        this.discard();
    }

    protected void parseStatement() throws IOException {
        ArrayList<Reference> lexicalUnits = new ArrayList<Reference>();
        String object = null;
        do {
            this.consumeWhiteSpaces();
            switch (this.getChar()) {
                case '<': {
                    lexicalUnits.add(new Reference(this.parseUri()));
                    break;
                }
                case '_': {
                    lexicalUnits.add(Link.createBlankRef(this.parseToken()));
                    break;
                }
                case '\"': {
                    int c = this.step();
                    this.discard();
                    while (!this.isEndOfFile(c) && c != 34) {
                        c = this.step();
                    }
                    object = this.getCurrentToken();
                    this.step();
                    this.discard();
                    break;
                }
                case '.': {
                    break;
                }
                case '#': {
                    this.parseComment();
                    break;
                }
                case '\u0000': {
                    break;
                }
                default: {
                    throw new IOException("This document does not seem to follow the N-Triples syntax. " + this.getParsingMessage());
                }
            }
        } while (!this.isEndOfFile(this.getChar()) && this.getChar() != '.' && this.getChar() != '}');
        if (!lexicalUnits.isEmpty()) {
            if (object != null) {
                this.getGraphHandler().link((Reference)lexicalUnits.get(0), (Reference)lexicalUnits.get(1), new Literal(object));
            } else {
                this.getGraphHandler().link((Reference)lexicalUnits.get(0), (Reference)lexicalUnits.get(1), (Reference)lexicalUnits.get(2));
            }
        }
    }

    protected String parseToken() throws IOException {
        int c;
        while (!this.isEndOfFile(c = this.step()) && !this.isDelimiter(c)) {
        }
        String result = this.getCurrentToken();
        return result;
    }

    protected String parseUri() throws IOException {
        StringBuilder builder = new StringBuilder();
        int c = this.step();
        while (c != 0 && c != 62) {
            if (!this.isWhiteSpace(c)) {
                builder.append((char)c);
            }
            c = this.step();
        }
        if (c == 62) {
            this.step();
        }
        this.discard();
        return builder.toString();
    }

    protected int step() throws IOException {
        ++this.scoutIndex;
        if (this.buffer[this.scoutIndex] == '\u0000') {
            if (this.scoutIndex == 4096) {
                ++this.scoutIndex;
                int len = this.br.read(this.buffer, 0, 4096);
                if (len == -1) {
                    this.buffer[this.scoutIndex] = '\u0000';
                } else {
                    this.buffer[4096 + len + 1] = '\u0000';
                }
            } else if (this.scoutIndex == 8193) {
                this.scoutIndex = 0;
                int len = this.br.read(this.buffer, 0, 4096);
                if (len == -1) {
                    this.buffer[this.scoutIndex] = '\u0000';
                } else {
                    this.buffer[len] = '\u0000';
                }
            }
        }
        return this.buffer[this.scoutIndex];
    }

    protected void step(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.step();
        }
    }

    protected void stepBack() {
        this.stepBack(1);
    }

    protected void stepBack(int n) {
        this.scoutIndex -= n;
        if (this.scoutIndex < 0) {
            this.scoutIndex = 8193 - this.scoutIndex;
        }
    }
}

