/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.rdf.internal.turtle;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.restlet.data.Reference;
import org.restlet.ext.rdf.Graph;
import org.restlet.ext.rdf.GraphHandler;
import org.restlet.ext.rdf.Literal;
import org.restlet.ext.rdf.internal.RdfConstants;
import org.restlet.ext.rdf.internal.ntriples.RdfNTriplesReader;
import org.restlet.ext.rdf.internal.turtle.BlankNodeToken;
import org.restlet.ext.rdf.internal.turtle.Context;
import org.restlet.ext.rdf.internal.turtle.LexicalUnit;
import org.restlet.ext.rdf.internal.turtle.ListToken;
import org.restlet.ext.rdf.internal.turtle.StringToken;
import org.restlet.ext.rdf.internal.turtle.Token;
import org.restlet.ext.rdf.internal.turtle.UriToken;
import org.restlet.representation.Representation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RdfTurtleReader
extends RdfNTriplesReader {
    private int blankNodeId = 0;
    private Context context = new Context();

    public RdfTurtleReader(Representation rdfN3Representation, GraphHandler graphHandler) throws IOException {
        super(rdfN3Representation, graphHandler);
        this.context.getKeywords().addAll(Arrays.asList("a", "is", "of", "this", "has"));
    }

    protected void generateLinks(List<LexicalUnit> lexicalUnits) {
        Object currentSubject = null;
        Reference currentPredicate = null;
        Object currentObject = null;
        int nbTokens = 0;
        boolean swapSubjectObject = false;
        block5: for (int i = 0; i < lexicalUnits.size(); ++i) {
            LexicalUnit lexicalUnit = lexicalUnits.get(i);
            switch (++nbTokens) {
                case 1: {
                    if (",".equals(lexicalUnit.getValue())) {
                        ++nbTokens;
                        continue block5;
                    }
                    if (";".equals(lexicalUnit.getValue())) continue block5;
                    currentSubject = lexicalUnit.resolve();
                    continue block5;
                }
                case 2: {
                    if ("is".equalsIgnoreCase(lexicalUnit.getValue())) {
                        --nbTokens;
                        swapSubjectObject = true;
                        continue block5;
                    }
                    if ("has".equalsIgnoreCase(lexicalUnit.getValue())) {
                        --nbTokens;
                        continue block5;
                    }
                    if ("a".equalsIgnoreCase(lexicalUnit.getValue())) {
                        currentPredicate = RdfConstants.PREDICATE_TYPE;
                        continue block5;
                    }
                    if ("!".equalsIgnoreCase(lexicalUnit.getValue())) {
                        currentObject = new BlankNodeToken(this.newBlankNodeId()).resolve();
                        currentPredicate = this.getPredicate(lexicalUnits.get(++i));
                        this.link(currentSubject, currentPredicate, currentObject);
                        currentSubject = currentObject;
                        nbTokens = 1;
                        continue block5;
                    }
                    if ("^".equalsIgnoreCase(lexicalUnit.getValue())) {
                        currentObject = currentSubject;
                        currentPredicate = this.getPredicate(lexicalUnits.get(++i));
                        currentSubject = new BlankNodeToken(this.newBlankNodeId()).resolve();
                        this.link(currentSubject, currentPredicate, currentObject);
                        nbTokens = 1;
                        continue block5;
                    }
                    currentPredicate = this.getPredicate(lexicalUnit);
                    continue block5;
                }
                case 3: {
                    if ("of".equalsIgnoreCase(lexicalUnit.getValue())) {
                        --nbTokens;
                        continue block5;
                    }
                    if (swapSubjectObject) {
                        this.link(lexicalUnit.resolve(), currentPredicate, currentSubject);
                    } else {
                        currentObject = lexicalUnit.resolve();
                        this.link(currentSubject, currentPredicate, currentObject);
                    }
                    nbTokens = 0;
                    swapSubjectObject = false;
                    continue block5;
                }
            }
        }
    }

    protected Context getContext() {
        return this.context;
    }

    private Reference getPredicate(LexicalUnit lexicalUnit) {
        Reference result = null;
        Object p = lexicalUnit.resolve();
        if (p instanceof Reference) {
            result = (Reference)p;
        } else if (p instanceof String) {
            result = new Reference((String)p);
        }
        return result;
    }

    @Override
    protected boolean isDelimiter(int c) {
        return this.isWhiteSpace(c) || c == 94 || c == 33 || c == 61 || c == 60 || c == 34 || c == 91 || c == 93 || c == 40 || c == 41 || c == 46 || c == 59 || c == 44 || c == 64;
    }

    protected void link(Object source, Reference typeRef, Object target) {
        if (source instanceof Reference) {
            if (target instanceof Reference) {
                this.getGraphHandler().link((Reference)source, typeRef, (Reference)target);
            } else if (target instanceof Literal) {
                this.getGraphHandler().link((Reference)source, typeRef, (Literal)target);
            } else {
                org.restlet.Context.getCurrentLogger().warning("The RDF Turtle document contains an object which is neither a Reference nor a literal: " + target);
                org.restlet.Context.getCurrentLogger().warning(this.getParsingMessage());
            }
        } else if (source instanceof Graph) {
            if (target instanceof Reference) {
                this.getGraphHandler().link((Graph)source, typeRef, (Reference)target);
            } else if (target instanceof Literal) {
                this.getGraphHandler().link((Graph)source, typeRef, (Literal)target);
            } else {
                org.restlet.Context.getCurrentLogger().warning("The RDF Turtle document contains an object which is neither a Reference nor a literal: " + target);
                org.restlet.Context.getCurrentLogger().warning(this.getParsingMessage());
            }
        }
    }

    protected String newBlankNodeId() {
        return "#_bn" + this.blankNodeId++;
    }

    @Override
    public void parse() throws IOException {
        this.step();
        do {
            this.consumeWhiteSpaces();
            switch (this.getChar()) {
                case '@': {
                    this.parseDirective(this.context);
                    break;
                }
                case '#': {
                    this.parseComment();
                    break;
                }
                case '.': {
                    this.step();
                    break;
                }
                default: {
                    this.parseStatement(this.context);
                }
            }
        } while (!this.isEndOfFile(this.getChar()));
    }

    protected void parseBlankNode(BlankNodeToken blankNode) throws IOException {
        this.step();
        block9: do {
            this.consumeWhiteSpaces();
            switch (this.getChar()) {
                case '(': {
                    blankNode.getLexicalUnits().add(new ListToken(this, this.context));
                    break;
                }
                case '<': {
                    this.stepBack();
                    blankNode.getLexicalUnits().add(new UriToken(this, this.context));
                    break;
                }
                case '_': {
                    blankNode.getLexicalUnits().add(new BlankNodeToken(this.parseToken()));
                    break;
                }
                case '\"': {
                    blankNode.getLexicalUnits().add(new StringToken(this, this.context));
                    break;
                }
                case '[': {
                    blankNode.getLexicalUnits().add(new BlankNodeToken(this, this.context));
                    break;
                }
                case ']': {
                    break;
                }
                case '.': {
                    this.step();
                    break;
                }
                default: {
                    if (this.isEndOfFile(this.getChar())) continue block9;
                    blankNode.getLexicalUnits().add(new Token(this, this.context));
                }
            }
        } while (!this.isEndOfFile(this.getChar()) && this.getChar() != ']');
        if (this.getChar() == ']') {
            this.step();
        }
    }

    protected void parseDirective(Context context) throws IOException {
        this.step();
        this.discard();
        String currentKeyword = this.parseToken();
        if ("base".equalsIgnoreCase(currentKeyword)) {
            this.consumeWhiteSpaces();
            String base = this.parseUri();
            Reference ref = new Reference(base);
            if (ref.isRelative()) {
                context.getBase().addSegment(base);
            } else {
                context.setBase(ref);
            }
            this.consumeStatement();
        } else if ("prefix".equalsIgnoreCase(currentKeyword)) {
            this.consumeWhiteSpaces();
            String prefix = this.parseToken();
            this.consumeWhiteSpaces();
            String uri = this.parseUri();
            context.getPrefixes().put(prefix, uri);
            this.consumeStatement();
        } else if ("keywords".equalsIgnoreCase(currentKeyword)) {
            int c;
            this.consumeWhiteSpaces();
            while (!this.isEndOfFile(c = this.step()) && c != 46) {
            }
            String strKeywords = this.getCurrentToken();
            String[] keywords = strKeywords.split(",");
            context.getKeywords().clear();
            for (String keyword : keywords) {
                context.getKeywords().add(keyword.trim());
            }
            this.consumeStatement();
        } else {
            org.restlet.Context.getCurrentLogger().warning("@" + currentKeyword + " directive is not supported.");
            this.consumeStatement();
        }
    }

    protected void parseList(ListToken listToken) throws IOException {
        this.step();
        block8: do {
            this.consumeWhiteSpaces();
            switch (this.getChar()) {
                case '(': {
                    listToken.getLexicalUnits().add(new ListToken(this, this.context));
                    break;
                }
                case '<': {
                    this.stepBack();
                    listToken.getLexicalUnits().add(new UriToken(this, this.context));
                    break;
                }
                case '_': {
                    listToken.getLexicalUnits().add(new BlankNodeToken(this.parseToken()));
                    break;
                }
                case '\"': {
                    listToken.getLexicalUnits().add(new StringToken(this, this.context));
                    break;
                }
                case '[': {
                    listToken.getLexicalUnits().add(new BlankNodeToken(this, this.context));
                    break;
                }
                case ')': {
                    break;
                }
                default: {
                    if (this.isEndOfFile(this.getChar())) continue block8;
                    listToken.getLexicalUnits().add(new Token(this, this.context));
                }
            }
        } while (!this.isEndOfFile(this.getChar()) && this.getChar() != ')');
        if (this.getChar() == ')') {
            this.step();
        }
    }

    protected void parseStatement(Context context) throws IOException {
        ArrayList<LexicalUnit> lexicalUnits = new ArrayList<LexicalUnit>();
        block14: do {
            this.consumeWhiteSpaces();
            switch (this.getChar()) {
                case '(': {
                    lexicalUnits.add(new ListToken(this, context));
                    break;
                }
                case '<': {
                    this.stepBack();
                    lexicalUnits.add(new UriToken(this, context));
                    break;
                }
                case '_': {
                    lexicalUnits.add(new BlankNodeToken(this.parseToken()));
                    break;
                }
                case '\"': {
                    lexicalUnits.add(new StringToken(this, context));
                    break;
                }
                case '[': {
                    lexicalUnits.add(new BlankNodeToken(this, context));
                    break;
                }
                case '!': {
                    lexicalUnits.add(new Token("!"));
                    this.step();
                    this.discard();
                    break;
                }
                case '^': {
                    lexicalUnits.add(new Token("^"));
                    this.step();
                    this.discard();
                    break;
                }
                case '@': {
                    this.step();
                    this.discard();
                    lexicalUnits.add(new Token(this, context));
                    this.discard();
                    break;
                }
                case ';': {
                    this.step();
                    this.discard();
                    lexicalUnits.add(new Token(";"));
                    break;
                }
                case ',': {
                    this.step();
                    this.discard();
                    lexicalUnits.add(new Token(","));
                    break;
                }
                case '#': {
                    this.parseComment();
                    break;
                }
                case '.': {
                    break;
                }
                default: {
                    if (this.isEndOfFile(this.getChar())) continue block14;
                    lexicalUnits.add(new Token(this, context));
                }
            }
        } while (!this.isEndOfFile(this.getChar()) && this.getChar() != '.');
        this.generateLinks(lexicalUnits);
    }

    protected void parseString(StringToken stringToken) throws IOException {
        int c2;
        int c1 = this.step();
        if (c1 == (c2 = this.step()) && c1 == 34) {
            stringToken.setMultiLines(true);
            this.step();
            this.discard();
            int[] tab = new int[3];
            int cpt = 0;
            int c = this.getChar();
            while (!this.isEndOfFile(c)) {
                if (c == 34) {
                    tab[++cpt - 1] = c;
                } else {
                    cpt = 0;
                }
                if (cpt == 3) {
                    this.stepBack(2);
                    stringToken.setValue(this.getCurrentToken());
                    this.step(3);
                    this.discard();
                    break;
                }
                c = this.step();
            }
        } else {
            stringToken.setMultiLines(false);
            this.stepBack(1);
            this.discard();
            int c = this.getChar();
            while (!this.isEndOfFile(c) && c != 34) {
                c = this.step();
            }
            stringToken.setValue(this.getCurrentToken());
            this.step();
            this.discard();
        }
        int c = this.getChar();
        if (c == 64) {
            stringToken.setLanguage(this.parseToken());
        } else if (c == 94) {
            c = this.step();
            if (c == 94) {
                stringToken.setType(this.parseToken());
            } else {
                this.stepBack();
            }
        }
    }

    protected void parseToken(Token token) throws IOException {
        int c;
        while (!this.isEndOfFile(c = this.step()) && !this.isDelimiter(c)) {
        }
        token.setValue(this.getCurrentToken());
    }

    protected void parseUri(UriToken uriToken) throws IOException {
        uriToken.setValue(this.parseUri());
    }
}

