/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.sip;

import org.restlet.data.Form;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.ext.sip.internal.AddressWriter;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Address
implements Cloneable {
    private String displayName;
    private Series<Parameter> parameters;
    private Reference reference;

    public Address() {
    }

    public Address(Reference reference) {
        this.reference = reference;
    }

    public Address(Reference reference, String displayName) {
        this.reference = reference;
        this.displayName = displayName;
    }

    public Address(String reference, String displayName) {
        this(new Reference(reference), displayName);
    }

    protected Object clone() throws CloneNotSupportedException {
        Address result = (Address)super.clone();
        result.reference = this.reference.clone();
        if (this.parameters != null) {
            result.parameters = new Form();
            for (Parameter param : this.parameters) {
                result.parameters.add(param.getName(), param.getValue());
            }
        }
        return result;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Series<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new Form();
        }
        return this.parameters;
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setParameters(Series<Parameter> parameters) {
        this.parameters = parameters;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public String toString() {
        return AddressWriter.write(this);
    }
}

