/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.ssl.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.restlet.ext.ssl.DefaultSslContextFactory;

public class WrapperSslServerSocketFactory
extends SSLServerSocketFactory {
    private final DefaultSslContextFactory contextFactory;
    private final SSLServerSocketFactory wrappedSocketFactory;

    public WrapperSslServerSocketFactory(DefaultSslContextFactory contextFactory, SSLServerSocketFactory wrappedSocketFactory) {
        this.wrappedSocketFactory = wrappedSocketFactory;
        this.contextFactory = contextFactory;
    }

    @Override
    public ServerSocket createServerSocket() throws IOException {
        SSLServerSocket result = (SSLServerSocket)this.getWrappedSocketFactory().createServerSocket();
        return this.initSslServerSocket(result);
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        SSLServerSocket result = (SSLServerSocket)this.getWrappedSocketFactory().createServerSocket(port);
        return this.initSslServerSocket(result);
    }

    @Override
    public ServerSocket createServerSocket(int port, int backLog) throws IOException {
        SSLServerSocket result = (SSLServerSocket)this.getWrappedSocketFactory().createServerSocket(port, backLog);
        return this.initSslServerSocket(result);
    }

    @Override
    public ServerSocket createServerSocket(int port, int backLog, InetAddress ifAddress) throws IOException {
        SSLServerSocket result = (SSLServerSocket)this.getWrappedSocketFactory().createServerSocket(port, backLog, ifAddress);
        return this.initSslServerSocket(result);
    }

    public DefaultSslContextFactory getContextFactory() {
        return this.contextFactory;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.getWrappedSocketFactory().getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.getWrappedSocketFactory().getSupportedCipherSuites();
    }

    public SSLServerSocketFactory getWrappedSocketFactory() {
        return this.wrappedSocketFactory;
    }

    protected SSLServerSocket initSslServerSocket(SSLServerSocket sslServerSocket) {
        if (this.getContextFactory().isNeedClientAuthentication()) {
            sslServerSocket.setNeedClientAuth(true);
        } else if (this.getContextFactory().isWantClientAuthentication()) {
            sslServerSocket.setWantClientAuth(true);
        }
        if (this.getContextFactory().getEnabledCipherSuites() != null || this.getContextFactory().getDisabledCipherSuites() != null) {
            sslServerSocket.setEnabledCipherSuites(this.getContextFactory().getSelectedCipherSuites(sslServerSocket.getSupportedCipherSuites()));
        }
        if (this.getContextFactory().getEnabledProtocols() != null || this.getContextFactory().getDisabledProtocols() != null) {
            sslServerSocket.setEnabledProtocols(this.getContextFactory().getSelectedSslProtocols(sslServerSocket.getSupportedProtocols()));
        }
        return sslServerSocket;
    }
}

