/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.ssl;

import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Status;
import org.restlet.security.Authenticator;
import org.restlet.security.User;

public class CertificateAuthenticator
extends Authenticator {
    public CertificateAuthenticator(Context context) {
        super(context);
    }

    protected List<Principal> getPrincipals(List<Certificate> certificateChain) {
        ArrayList<X500Principal> principals = null;
        if (certificateChain != null && certificateChain.size() > 0) {
            Certificate userCert = certificateChain.get(0);
            if (userCert instanceof X509Certificate) {
                principals = new ArrayList<X500Principal>();
                principals.add(((X509Certificate)userCert).getSubjectX500Principal());
            }
            return principals;
        }
        return null;
    }

    protected User getUser(Principal principal) {
        if (principal != null) {
            return new User(principal.getName());
        }
        return null;
    }

    protected boolean authenticate(Request request, Response response) {
        List certchain = request.getClientInfo().getCertificates();
        List<Principal> principals = this.getPrincipals(certchain);
        if (principals != null && principals.size() > 0) {
            request.getClientInfo().getPrincipals().addAll(principals);
            User user = this.getUser(principals.get(0));
            if (user != null) {
                request.getClientInfo().setUser(user);
            }
            return true;
        }
        response.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
        return false;
    }
}

