/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http.connector;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.http.connector.BaseHelper;
import org.restlet.engine.http.connector.ClientConnection;
import org.restlet.engine.http.connector.Connection;
import org.restlet.engine.http.connector.ConnectionState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseClientHelper
extends BaseHelper<Client> {
    private volatile SocketFactory regularSocketFactory = null;
    private volatile SocketFactory secureSocketFactory = null;

    public BaseClientHelper(Client connector) {
        super(connector, true);
    }

    @Override
    protected Connection<Client> createConnection(BaseHelper<Client> helper, Socket socket, SocketChannel socketChannel) throws IOException {
        return new ClientConnection(helper, socket, socketChannel);
    }

    protected SocketFactory createSecureSocketFactory() throws IOException, GeneralSecurityException {
        String certAlgorithm = this.getCertAlgorithm();
        String keystorePath = this.getKeystorePath();
        String keystorePassword = this.getKeystorePassword();
        String keyPassword = this.getKeyPassword();
        String truststoreType = this.getTruststoreType();
        String truststorePath = this.getTruststorePath();
        String truststorePassword = this.getTruststorePassword();
        String secureRandomAlgorithm = this.getSecureRandomAlgorithm();
        String securityProvider = this.getSecurityProvider();
        FileInputStream keystoreInputStream = null;
        if (keystorePath != null && new File(keystorePath).exists()) {
            keystoreInputStream = new FileInputStream(keystorePath);
        }
        KeyStore keystore = null;
        if (keystoreInputStream != null) {
            try {
                keystore = KeyStore.getInstance(this.getKeystoreType());
                keystore.load(keystoreInputStream, keystorePassword == null ? null : keystorePassword.toCharArray());
            }
            catch (IOException ioe) {
                this.getLogger().log(Level.WARNING, "Unable to load the key store", ioe);
                keystore = null;
            }
        }
        KeyManager[] keyManagers = null;
        if (keystore != null && keyPassword != null) {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(certAlgorithm);
            keyManagerFactory.init(keystore, keyPassword.toCharArray());
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        FileInputStream truststoreInputStream = null;
        if (truststorePath != null && new File(truststorePath).exists()) {
            truststoreInputStream = new FileInputStream(truststorePath);
        }
        KeyStore truststore = null;
        if (truststoreType != null && truststoreInputStream != null) {
            try {
                truststore = KeyStore.getInstance(truststoreType);
                truststore.load(truststoreInputStream, truststorePassword == null ? null : truststorePassword.toCharArray());
            }
            catch (IOException ioe) {
                this.getLogger().log(Level.WARNING, "Unable to load the trust store", ioe);
                truststore = null;
            }
        }
        TrustManager[] trustManagers = null;
        if (truststore != null) {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(certAlgorithm);
            trustManagerFactory.init(truststore);
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        SecureRandom secureRandom = secureRandomAlgorithm == null ? null : SecureRandom.getInstance(secureRandomAlgorithm);
        SSLContext context = securityProvider == null ? SSLContext.getInstance(this.getSslProtocol()) : SSLContext.getInstance(this.getSslProtocol(), securityProvider);
        context.init(keyManagers, trustManagers, secureRandom);
        return context.getSocketFactory();
    }

    public Socket createSocket(boolean secure, String hostDomain, int hostPort) throws UnknownHostException, IOException {
        Socket result = null;
        SocketFactory factory = this.getSocketFactory(secure);
        if (factory != null) {
            result = factory.createSocket();
            InetSocketAddress address = new InetSocketAddress(hostDomain, hostPort);
            result.connect(address, this.getConnectTimeout());
            result.setTcpNoDelay(this.getTcpNoDelay());
        }
        return result;
    }

    protected SocketFactory createSocketFactory(boolean secure) {
        SocketFactory result;
        block4: {
            result = null;
            if (secure) {
                try {
                    return this.createSecureSocketFactory();
                }
                catch (IOException ex) {
                    this.getLogger().log(Level.SEVERE, "Could not create secure socket factory: " + ex.getMessage(), ex);
                    break block4;
                }
                catch (GeneralSecurityException ex) {
                    this.getLogger().log(Level.SEVERE, "Could not create secure socket factory: " + ex.getMessage(), ex);
                    break block4;
                }
            }
            result = SocketFactory.getDefault();
        }
        return result;
    }

    public String getCertAlgorithm() {
        return this.getHelpedParameters().getFirstValue("certAlgorithm", "SunX509");
    }

    public int getConnectTimeout() {
        return ((Client)this.getHelped()).getConnectTimeout();
    }

    public String getKeyPassword() {
        return this.getHelpedParameters().getFirstValue("keyPassword", System.getProperty("javax.net.ssl.keyStorePassword"));
    }

    public String getKeystorePassword() {
        return this.getHelpedParameters().getFirstValue("keystorePassword", System.getProperty("javax.net.ssl.keyStorePassword"));
    }

    public String getKeystorePath() {
        return this.getHelpedParameters().getFirstValue("keystorePath", System.getProperty("user.home") + File.separator + ".keystore");
    }

    public String getKeystoreType() {
        return this.getHelpedParameters().getFirstValue("keystoreType", "JKS");
    }

    public SocketFactory getRegularSocketFactory() {
        return this.regularSocketFactory;
    }

    public String getSecureRandomAlgorithm() {
        return this.getHelpedParameters().getFirstValue("secureRandomAlgorithm", null);
    }

    public SocketFactory getSecureSocketFactory() {
        return this.secureSocketFactory;
    }

    public String getSecurityProvider() {
        return this.getHelpedParameters().getFirstValue("securityProvider", null);
    }

    public SocketFactory getSocketFactory(boolean secure) {
        return secure ? this.getSecureSocketFactory() : this.getRegularSocketFactory();
    }

    public String getSslProtocol() {
        return this.getHelpedParameters().getFirstValue("sslProtocol", "TLS");
    }

    public boolean getTcpNoDelay() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("tcpNoDelay", "false"));
    }

    public String getTruststorePassword() {
        return this.getHelpedParameters().getFirstValue("truststorePassword", System.getProperty("javax.net.ssl.keyStorePassword"));
    }

    public String getTruststorePath() {
        return this.getHelpedParameters().getFirstValue("truststorePath", null);
    }

    public String getTruststoreType() {
        return this.getHelpedParameters().getFirstValue("truststoreType", System.getProperty("javax.net.ssl.trustStoreType"));
    }

    @Override
    public void handle(Request request, Response response) {
        try {
            if (request.getOnResponse() == null) {
                CountDownLatch latch = new CountDownLatch(1);
                request.getAttributes().put("org.restlet.engine.http.connector.latch", latch);
                this.getOutboundMessages().add(response);
                latch.await();
            } else {
                this.getOutboundMessages().add(response);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.INFO, "Error while handling a " + request.getProtocol().getName() + " client request", e);
            response.setStatus(Status.CONNECTOR_ERROR_INTERNAL, e);
        }
    }

    @Override
    public void handleInbound(Response response) {
        if (response != null) {
            CountDownLatch latch;
            if (response.getRequest().getOnResponse() != null) {
                response.getRequest().getOnResponse().handle(response.getRequest(), response);
            }
            if (!response.getStatus().isInformational() && (latch = (CountDownLatch)response.getRequest().getAttributes().get("org.restlet.engine.http.connector.latch")) != null) {
                latch.countDown();
            }
        }
    }

    @Override
    public void handleOutbound(Response response) {
        block11: {
            if (response != null && response.getRequest() != null) {
                Request request = response.getRequest();
                Reference resourceRef = request.getResourceRef().isRelative() ? request.getResourceRef().getTargetRef() : request.getResourceRef();
                String hostDomain = resourceRef.getHostDomain();
                int hostPort = resourceRef.getHostPort();
                if (hostPort == -1) {
                    hostPort = resourceRef.getSchemeProtocol() != null ? resourceRef.getSchemeProtocol().getDefaultPort() : this.getProtocols().get(0).getDefaultPort();
                }
                try {
                    InetSocketAddress socketAddress = new InetSocketAddress(hostDomain, hostPort);
                    int hostConnectionCount = 0;
                    int bestCount = 0;
                    Connection<Client> bestConn = null;
                    boolean foundConn = false;
                    for (Connection currConn : this.getConnections()) {
                        if (!socketAddress.getAddress().equals(currConn.getSocket().getInetAddress()) || socketAddress.getPort() != currConn.getSocket().getPort()) continue;
                        ++hostConnectionCount;
                        if (currConn.getState().equals((Object)ConnectionState.OPEN) && !currConn.isOutboundBusy()) {
                            bestConn = currConn;
                            foundConn = true;
                            continue;
                        }
                        int currCount = currConn.getOutboundMessages().size();
                        if (bestCount <= currCount) continue;
                        bestCount = currCount;
                        bestConn = currConn;
                    }
                    if (!(foundConn || this.getMaxTotalConnections() != -1 && this.getConnections().size() >= this.getMaxTotalConnections() || this.getMaxConnectionsPerHost() != -1 && hostConnectionCount >= this.getMaxConnectionsPerHost())) {
                        bestConn = this.createConnection(this, this.createSocket(request.isConfidential(), hostDomain, hostPort), (SocketChannel)null);
                        bestConn.open();
                        bestCount = 0;
                    }
                    if (bestConn != null) {
                        bestConn.getOutboundMessages().add(response);
                        this.getConnections().add(bestConn);
                        if (!request.isExpectingResponse()) {
                            bestConn.writeMessages();
                            CountDownLatch latch = (CountDownLatch)response.getRequest().getAttributes().get("org.restlet.engine.http.connector.latch");
                            if (latch != null) {
                                latch.countDown();
                            }
                        }
                    } else {
                        this.getLogger().warning("Unable to find a connection to send the request");
                    }
                }
                catch (IOException ioe) {
                    this.getLogger().log(Level.FINE, "An error occured during the communication with the remote server.", ioe);
                    response.setStatus(Status.CONNECTOR_ERROR_COMMUNICATION, ioe);
                    CountDownLatch latch = (CountDownLatch)response.getRequest().getAttributes().get("org.restlet.engine.http.connector.latch");
                    if (latch == null) break block11;
                    latch.countDown();
                }
            }
        }
    }

    public void setRegularSocketFactory(SocketFactory regularSocketFactory) {
        this.regularSocketFactory = regularSocketFactory;
    }

    public void setSecureSocketFactory(SocketFactory secureSocketFactory) {
        this.secureSocketFactory = secureSocketFactory;
    }

    @Override
    public synchronized void start() throws Exception {
        this.setRegularSocketFactory(this.createSocketFactory(false));
        this.setSecureSocketFactory(this.createSocketFactory(true));
        super.start();
    }

    @Override
    public synchronized void stop() throws Exception {
        this.setRegularSocketFactory(null);
        this.setSecureSocketFactory(null);
        super.stop();
    }
}

