/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http.header;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Message;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.AuthenticationInfo;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.CharacterSet;
import org.restlet.data.ClientInfo;
import org.restlet.data.Conditions;
import org.restlet.data.CookieSetting;
import org.restlet.data.Digest;
import org.restlet.data.Dimension;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.data.Tag;
import org.restlet.data.Warning;
import org.restlet.engine.http.header.CacheControlReader;
import org.restlet.engine.http.header.CacheControlUtils;
import org.restlet.engine.http.header.ContentType;
import org.restlet.engine.http.header.CookieReader;
import org.restlet.engine.http.header.CookieUtils;
import org.restlet.engine.http.header.DispositionReader;
import org.restlet.engine.http.header.DispositionUtils;
import org.restlet.engine.http.header.HeaderReader;
import org.restlet.engine.http.header.PreferenceUtils;
import org.restlet.engine.http.header.RangeUtils;
import org.restlet.engine.http.header.WarningReader;
import org.restlet.engine.http.header.WarningUtils;
import org.restlet.engine.security.AuthenticatorUtils;
import org.restlet.engine.util.Base64;
import org.restlet.engine.util.DateUtils;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderUtils {
    public static void addEntityHeaders(Representation entity, Series<Parameter> headers) {
        if (entity == null || !entity.isAvailable()) {
            headers.add("Content-Length", "0");
        } else {
            long size;
            StringBuilder value;
            if (!entity.getEncodings().isEmpty()) {
                if (entity.getEncodings().size() == 1) {
                    headers.add("Content-Encoding", entity.getEncodings().get(0).getName());
                } else {
                    value = new StringBuilder();
                    for (Encoding encoding : entity.getEncodings()) {
                        if (encoding.equals(Encoding.IDENTITY)) continue;
                        if (value.length() > 0) {
                            value.append(", ");
                        }
                        value.append(encoding.getName());
                    }
                    if (value.length() > 0) {
                        headers.add("Content-Encoding", value.toString());
                    }
                }
            }
            if (!entity.getLanguages().isEmpty()) {
                if (entity.getLanguages().size() == 1) {
                    headers.add("Content-Language", entity.getLanguages().get(0).toString());
                } else {
                    value = new StringBuilder();
                    for (Language language : entity.getLanguages()) {
                        if (value.length() > 0) {
                            value.append(", ");
                        }
                        value.append(language.getName());
                    }
                    headers.add("Content-Language", value.toString());
                }
            }
            if ((size = entity.getAvailableSize()) != -1L) {
                headers.add("Content-Length", Long.toString(size));
            }
            if (entity.getIdentifier() != null) {
                headers.add("Content-Location", entity.getIdentifier().getTargetRef().toString());
            }
            if (entity.getDigest() != null && "MD5".equals(entity.getDigest().getAlgorithm())) {
                headers.add("Content-MD5", new String(Base64.encode(entity.getDigest().getValue(), false)));
            }
            if (entity.getRange() != null) {
                try {
                    headers.add("Content-Range", RangeUtils.formatContentRange(entity.getRange(), entity.getSize()));
                }
                catch (Exception e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Unable to format the HTTP Content-Range header", e);
                }
            }
            if (entity.getMediaType() != null) {
                String contentType = entity.getMediaType().toString();
                if (entity.getMediaType().getParameters().getFirstValue("charset") == null && entity.getCharacterSet() != null) {
                    contentType = contentType + "; charset=" + entity.getCharacterSet().getName();
                }
                headers.add("Content-Type", contentType);
            }
            if (entity.getExpirationDate() != null) {
                headers.add("Expires", DateUtils.format(entity.getExpirationDate()));
            }
            if (entity.getModificationDate() != null) {
                headers.add("Last-Modified", HeaderUtils.formatDate(entity.getModificationDate(), false));
            }
            if (entity.getTag() != null) {
                headers.add("ETag", entity.getTag().format());
            }
            if (entity.getDisposition() != null && !"none".equals(entity.getDisposition().getType())) {
                headers.add("Content-Disposition", DispositionUtils.format(entity.getDisposition()));
            }
        }
    }

    public static void addExtensionHeaders(Series<Parameter> existingHeaders, Series<Parameter> additionalHeaders) {
        if (additionalHeaders != null) {
            for (Parameter param : additionalHeaders) {
                if (param.getName().equalsIgnoreCase("Accept") || param.getName().equalsIgnoreCase("Accept-Charset") || param.getName().equalsIgnoreCase("Accept-Encoding") || param.getName().equalsIgnoreCase("Accept-Language") || param.getName().equalsIgnoreCase("Accept-Ranges") || param.getName().equalsIgnoreCase("Age") || param.getName().equalsIgnoreCase("Allow") || param.getName().equalsIgnoreCase("Authentication-Info") || param.getName().equalsIgnoreCase("Authorization") || param.getName().equalsIgnoreCase("Cache-Control") || param.getName().equalsIgnoreCase("Connection") || param.getName().equalsIgnoreCase("Content-Disposition") || param.getName().equalsIgnoreCase("Content-Encoding") || param.getName().equalsIgnoreCase("Content-Language") || param.getName().equalsIgnoreCase("Content-Length") || param.getName().equalsIgnoreCase("Content-Location") || param.getName().equalsIgnoreCase("Content-MD5") || param.getName().equalsIgnoreCase("Content-Range") || param.getName().equalsIgnoreCase("Content-Type") || param.getName().equalsIgnoreCase("Cookie") || param.getName().equalsIgnoreCase("Date") || param.getName().equalsIgnoreCase("ETag") || param.getName().equalsIgnoreCase("Expires") || param.getName().equalsIgnoreCase("From") || param.getName().equalsIgnoreCase("Host") || param.getName().equalsIgnoreCase("If-Match") || param.getName().equalsIgnoreCase("If-Modified-Since") || param.getName().equalsIgnoreCase("If-None-Match") || param.getName().equalsIgnoreCase("If-Range") || param.getName().equalsIgnoreCase("If-Unmodified-Since") || param.getName().equalsIgnoreCase("Last-Modified") || param.getName().equalsIgnoreCase("Location") || param.getName().equalsIgnoreCase("Max-Forwards") || param.getName().equalsIgnoreCase("Proxy-Authenticate") || param.getName().equalsIgnoreCase("Proxy-Authorization") || param.getName().equalsIgnoreCase("Range") || param.getName().equalsIgnoreCase("Referer") || param.getName().equalsIgnoreCase("Retry-After") || param.getName().equalsIgnoreCase("Server") || param.getName().equalsIgnoreCase("Set-Cookie") || param.getName().equalsIgnoreCase("Set-Cookie2") || param.getName().equalsIgnoreCase("User-Agent") || param.getName().equalsIgnoreCase("Vary") || param.getName().equalsIgnoreCase("Warning") || param.getName().equalsIgnoreCase("WWW-Authenticate")) {
                    Context.getCurrentLogger().warning("Addition of the standard header \"" + param.getName() + "\" is not allowed. Please use the equivalent property in the Restlet API.");
                    continue;
                }
                if (param.getName().equalsIgnoreCase("Expect") || param.getName().equalsIgnoreCase("Pragma") || param.getName().equalsIgnoreCase("Trailer") || param.getName().equalsIgnoreCase("Transfer-Encoding") || param.getName().equalsIgnoreCase("TE") || param.getName().equalsIgnoreCase("Upgrade") || param.getName().equalsIgnoreCase("Via")) {
                    Context.getCurrentLogger().info("Addition of the standard header \"" + param.getName() + "\" is discouraged as a future versions of the Restlet API will directly support it.");
                    existingHeaders.add(param);
                    continue;
                }
                existingHeaders.add(param);
            }
        }
    }

    public static void addGeneralHeaders(Message message, Series<Parameter> headers) {
        if (!message.getCacheDirectives().isEmpty()) {
            headers.add("Cache-Control", CacheControlUtils.format(message.getCacheDirectives()));
        }
        if (message.getDate() == null) {
            message.setDate(new Date());
        }
        headers.add("Date", DateUtils.format(message.getDate()));
        if (!message.getWarnings().isEmpty()) {
            for (Warning warning : message.getWarnings()) {
                headers.add("Warning", WarningUtils.format(warning));
            }
        }
    }

    public static void addRequestHeaders(Request request, Series<Parameter> headers) throws IllegalArgumentException {
        ChallengeResponse proxyChallengeResponse;
        int i;
        Conditions condition;
        Reference hostRef;
        HeaderUtils.addGeneralHeaders(request, headers);
        ClientInfo client = request.getClientInfo();
        if (client.getAcceptedMediaTypes().size() > 0) {
            try {
                headers.add("Accept", PreferenceUtils.format(client.getAcceptedMediaTypes()));
            }
            catch (IOException ioe) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to format the HTTP Accept header", ioe);
            }
        } else {
            headers.add("Accept", MediaType.ALL.getName());
        }
        if (client.getAcceptedCharacterSets().size() > 0) {
            try {
                headers.add("Accept-Charset", PreferenceUtils.format(client.getAcceptedCharacterSets()));
            }
            catch (IOException ioe) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to format the HTTP Accept header", ioe);
            }
        }
        if (client.getAcceptedEncodings().size() > 0) {
            try {
                headers.add("Accept-Encoding", PreferenceUtils.format(client.getAcceptedEncodings()));
            }
            catch (IOException ioe) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to format the HTTP Accept header", ioe);
            }
        }
        if (client.getAcceptedLanguages().size() > 0) {
            try {
                headers.add("Accept-Language", PreferenceUtils.format(client.getAcceptedLanguages()));
            }
            catch (IOException ioe) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to format the HTTP Accept header", ioe);
            }
        }
        if (request.getClientInfo().getFrom() != null) {
            headers.add("From", request.getClientInfo().getFrom());
        }
        Reference reference = hostRef = request.getResourceRef().getBaseRef() != null ? request.getResourceRef().getBaseRef() : request.getResourceRef();
        if (hostRef.getHostDomain() != null) {
            String host = hostRef.getHostDomain();
            int hostRefPortValue = hostRef.getHostPort();
            if (hostRefPortValue != -1 && hostRefPortValue != request.getProtocol().getDefaultPort()) {
                host = host + ':' + hostRefPortValue;
            }
            headers.add("Host", host);
        }
        if (!(condition = request.getConditions()).getMatch().isEmpty()) {
            StringBuilder value = new StringBuilder();
            for (i = 0; i < condition.getMatch().size(); ++i) {
                if (i > 0) {
                    value.append(", ");
                }
                value.append(condition.getMatch().get(i).format());
            }
            headers.add("If-Match", value.toString());
        }
        if (condition.getModifiedSince() != null) {
            String imsDate = DateUtils.format(condition.getModifiedSince());
            headers.add("If-Modified-Since", imsDate);
        }
        if (!condition.getNoneMatch().isEmpty()) {
            StringBuilder value = new StringBuilder();
            for (i = 0; i < condition.getNoneMatch().size(); ++i) {
                if (i > 0) {
                    value.append(", ");
                }
                value.append(condition.getNoneMatch().get(i).format());
            }
            headers.add("If-None-Match", value.toString());
        }
        if (condition.getRangeTag() != null && condition.getRangeDate() != null) {
            Context.getCurrentLogger().log(Level.WARNING, "Unable to format the HTTP If-Range header due to the presence of both entity tag and modification date.");
        } else if (condition.getRangeTag() != null) {
            headers.add("If-Range", condition.getRangeTag().format());
        } else if (condition.getRangeDate() != null) {
            String rDate = DateUtils.format(condition.getRangeDate(), DateUtils.FORMAT_RFC_1123.get(0));
            headers.add("If-Range", rDate);
        }
        if (condition.getUnmodifiedSince() != null) {
            String iusDate = DateUtils.format(condition.getUnmodifiedSince(), DateUtils.FORMAT_RFC_1123.get(0));
            headers.add("If-Unmodified-Since", iusDate);
        }
        if (request.getMaxForwards() > -1) {
            headers.add("Max-Forwards", Integer.toString(request.getMaxForwards()));
        }
        if (!request.getRanges().isEmpty()) {
            headers.add("Range", RangeUtils.formatRanges(request.getRanges()));
        }
        if (request.getReferrerRef() != null) {
            headers.add("Referer", request.getReferrerRef().toString());
        }
        if (request.getClientInfo().getAgent() != null) {
            headers.add("User-Agent", request.getClientInfo().getAgent());
        } else {
            headers.add("User-Agent", "Restlet-Framework/2.0m7");
        }
        if (request.getCookies().size() > 0) {
            String cookies = CookieUtils.format(request.getCookies());
            headers.add("Cookie", cookies);
        }
        Series additionalHeaders = (Series)request.getAttributes().get("org.restlet.http.headers");
        HeaderUtils.addExtensionHeaders(headers, additionalHeaders);
        ChallengeResponse challengeResponse = request.getChallengeResponse();
        if (challengeResponse != null) {
            try {
                headers.add("Authorization", AuthenticatorUtils.formatResponse(challengeResponse, request, headers));
            }
            catch (IOException e) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to write the Authorization header", e);
            }
        }
        if ((proxyChallengeResponse = request.getProxyChallengeResponse()) != null) {
            try {
                headers.add("Proxy-Authorization", AuthenticatorUtils.formatResponse(proxyChallengeResponse, request, headers));
            }
            catch (IOException e) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to write the Proxy-Authorization header", e);
            }
        }
    }

    public static void addResponseHeaders(Response response, Series<Parameter> headers) throws IllegalArgumentException {
        Set<Dimension> dimensions;
        String vary;
        HeaderUtils.addGeneralHeaders(response, headers);
        if (response.getServerInfo().isAcceptingRanges()) {
            headers.add("Accept-Ranges", "bytes");
        }
        if (response.getAge() > 0) {
            headers.add("Age", Integer.toString(response.getAge()));
        }
        if (response.getStatus().equals(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED) || Method.OPTIONS.equals(response.getRequest().getMethod())) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Method method : response.getAllowedMethods()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(method.getName());
            }
            headers.add("Allow", sb.toString());
        }
        if (response.getLocationRef() != null) {
            headers.add("Location", response.getLocationRef().getTargetRef().toString());
        }
        if (response.getProxyChallengeRequests() != null) {
            for (ChallengeRequest challengeRequest : response.getProxyChallengeRequests()) {
                headers.add("Proxy-Authenticate", AuthenticatorUtils.formatRequest(challengeRequest, response, headers));
            }
        }
        if (response.getRetryAfter() != null) {
            headers.add("Retry-After", DateUtils.format(response.getRetryAfter()));
        }
        if (response.getServerInfo() != null && response.getServerInfo().getAgent() != null) {
            headers.add("Server", response.getServerInfo().getAgent());
        } else {
            headers.add("Server", "Restlet-Framework/2.0m7");
        }
        if (!(response.getRequest().getClientInfo().getAgent() != null && response.getRequest().getClientInfo().getAgent().contains("MSIE") || (vary = HeaderUtils.createVaryHeader(dimensions = response.getDimensions())) == null)) {
            headers.add("Vary", vary);
        }
        if (response.getChallengeRequests() != null) {
            for (ChallengeRequest challengeRequest : response.getChallengeRequests()) {
                headers.add("WWW-Authenticate", AuthenticatorUtils.formatRequest(challengeRequest, response, headers));
            }
        }
        if (response.getAuthenticationInfo() != null) {
            try {
                headers.add("Authentication-Info", AuthenticatorUtils.formatAuthenticationInfo(response.getAuthenticationInfo()));
            }
            catch (IOException e) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to write the Authentication-Info header", e);
            }
        }
        Series<CookieSetting> cookies = response.getCookieSettings();
        for (int i = 0; i < cookies.size(); ++i) {
            headers.add("Set-Cookie", CookieUtils.format((CookieSetting)cookies.get(i)));
        }
        Series additionalHeaders = (Series)response.getAttributes().get("org.restlet.http.headers");
        HeaderUtils.addExtensionHeaders(headers, additionalHeaders);
    }

    public static Appendable appendQuote(CharSequence source, Appendable destination) throws IOException {
        destination.append('\"');
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c == '\"') {
                destination.append("\\\"");
                continue;
            }
            if (c == '\\') {
                destination.append("\\\\");
                continue;
            }
            destination.append(c);
        }
        destination.append('\"');
        return destination;
    }

    public static Appendable appendUriEncoded(CharSequence source, Appendable destination, CharacterSet characterSet) throws IOException {
        destination.append(Reference.encode(((Object)source).toString(), characterSet));
        return destination;
    }

    public static Representation copyResponseEntityHeaders(Iterable<Parameter> responseHeaders, Representation representation) throws NumberFormatException {
        Representation result = representation == null ? new EmptyRepresentation() : representation;
        boolean entityHeaderFound = false;
        for (Parameter header : responseHeaders) {
            String value;
            HeaderReader hr;
            if (header.getName().equalsIgnoreCase("Content-Type")) {
                ContentType contentType = new ContentType(header.getValue());
                result.setMediaType(contentType.getMediaType());
                if (result.getCharacterSet() == null || contentType.getCharacterSet() != null) {
                    result.setCharacterSet(contentType.getCharacterSet());
                }
                entityHeaderFound = true;
                continue;
            }
            if (header.getName().equalsIgnoreCase("Content-Length")) {
                entityHeaderFound = true;
                continue;
            }
            if (header.getName().equalsIgnoreCase("Expires")) {
                result.setExpirationDate(HeaderUtils.parseDate(header.getValue(), false));
                entityHeaderFound = true;
                continue;
            }
            if (header.getName().equalsIgnoreCase("Content-Encoding")) {
                hr = new HeaderReader(header.getValue());
                value = hr.readValue();
                while (value != null) {
                    Encoding encoding = new Encoding(value);
                    if (!encoding.equals(Encoding.IDENTITY)) {
                        result.getEncodings().add(encoding);
                    }
                    value = hr.readValue();
                }
                entityHeaderFound = true;
                continue;
            }
            if (header.getName().equalsIgnoreCase("Content-Language")) {
                hr = new HeaderReader(header.getValue());
                value = hr.readValue();
                while (value != null) {
                    result.getLanguages().add(new Language(value));
                    value = hr.readValue();
                }
                entityHeaderFound = true;
                continue;
            }
            if (header.getName().equalsIgnoreCase("Last-Modified")) {
                result.setModificationDate(HeaderUtils.parseDate(header.getValue(), false));
                entityHeaderFound = true;
                continue;
            }
            if (header.getName().equalsIgnoreCase("ETag")) {
                result.setTag(Tag.parse(header.getValue()));
                entityHeaderFound = true;
                continue;
            }
            if (header.getName().equalsIgnoreCase("Content-Location")) {
                result.setIdentifier(header.getValue());
                entityHeaderFound = true;
                continue;
            }
            if (header.getName().equalsIgnoreCase("Content-Disposition")) {
                try {
                    DispositionReader r = new DispositionReader(header.getValue());
                    result.setDisposition(r.readDisposition());
                    entityHeaderFound = true;
                }
                catch (IOException ioe) {
                    Context.getCurrentLogger().log(Level.WARNING, "Error during Content-Disposition header parsing. Header: " + header.getValue(), ioe);
                }
                continue;
            }
            if (header.getName().equalsIgnoreCase("Content-Range")) {
                RangeUtils.parseContentRange(header.getValue(), result);
                entityHeaderFound = true;
                continue;
            }
            if (!header.getName().equalsIgnoreCase("Content-MD5")) continue;
            result.setDigest(new Digest("MD5", Base64.decode(header.getValue())));
            entityHeaderFound = true;
        }
        if (representation == null && !entityHeaderFound) {
            result = null;
        }
        return result;
    }

    public static void copyResponseTransportHeaders(Series<Parameter> headers, Response response) {
        for (Parameter header : headers) {
            HeaderReader hr;
            ChallengeRequest request;
            if (header.getName().equalsIgnoreCase("Location")) {
                response.setLocationRef(header.getValue());
                continue;
            }
            if (header.getName().equalsIgnoreCase("Age")) {
                try {
                    response.setAge(Integer.parseInt(header.getValue()));
                }
                catch (NumberFormatException nfe) {
                    Context.getCurrentLogger().log(Level.WARNING, "Error during Age header parsing. Header: " + header.getValue(), nfe);
                }
                continue;
            }
            if (header.getName().equalsIgnoreCase("Date")) {
                Date date = DateUtils.parse(header.getValue());
                if (date == null) {
                    date = new Date();
                }
                response.setDate(date);
                continue;
            }
            if (header.getName().equalsIgnoreCase("Retry-After")) {
                Date retryAfter = DateUtils.parse(header.getValue());
                if (retryAfter == null) {
                    try {
                        int retryAfterSecs = Integer.parseInt(header.getValue());
                        Calendar calendar = Calendar.getInstance();
                        calendar.add(13, retryAfterSecs);
                        retryAfter = calendar.getTime();
                    }
                    catch (NumberFormatException nfe) {
                        Context.getCurrentLogger().log(Level.WARNING, "Error during Retry-After header parsing. Header: " + header.getValue(), nfe);
                    }
                }
                response.setRetryAfter(retryAfter);
                continue;
            }
            if (header.getName().equalsIgnoreCase("Set-Cookie") || header.getName().equalsIgnoreCase("Set-Cookie2")) {
                try {
                    CookieReader cr = new CookieReader(header.getValue());
                    response.getCookieSettings().add(cr.readCookieSetting());
                }
                catch (Exception e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Error during cookie setting parsing. Header: " + header.getValue(), e);
                }
                continue;
            }
            if (header.getName().equalsIgnoreCase("WWW-Authenticate")) {
                request = AuthenticatorUtils.parseRequest(response, header.getValue(), headers);
                response.getChallengeRequests().add(request);
                continue;
            }
            if (header.getName().equalsIgnoreCase("Proxy-Authenticate")) {
                request = AuthenticatorUtils.parseRequest(response, header.getValue(), headers);
                response.getProxyChallengeRequests().add(request);
                continue;
            }
            if (header.getName().equalsIgnoreCase("Authentication-Info")) {
                AuthenticationInfo authenticationInfo = AuthenticatorUtils.parseAuthenticationInfo(header.getValue());
                response.setAuthenticationInfo(authenticationInfo);
                continue;
            }
            if (header.getName().equalsIgnoreCase("Server")) {
                response.getServerInfo().setAgent(header.getValue());
                continue;
            }
            if (header.getName().equalsIgnoreCase("Allow")) {
                hr = new HeaderReader(header.getValue());
                String value = hr.readValue();
                Set<Method> allowedMethods = response.getAllowedMethods();
                while (value != null) {
                    allowedMethods.add(Method.valueOf(value));
                    value = hr.readValue();
                }
                continue;
            }
            if (header.getName().equalsIgnoreCase("Vary")) {
                hr = new HeaderReader(header.getValue());
                String value = hr.readValue();
                Set<Dimension> dimensions = response.getDimensions();
                while (value != null) {
                    if (value.equalsIgnoreCase("Accept")) {
                        dimensions.add(Dimension.MEDIA_TYPE);
                    } else if (value.equalsIgnoreCase("Accept-Charset")) {
                        dimensions.add(Dimension.CHARACTER_SET);
                    } else if (value.equalsIgnoreCase("Accept-Encoding")) {
                        dimensions.add(Dimension.ENCODING);
                    } else if (value.equalsIgnoreCase("Accept-Language")) {
                        dimensions.add(Dimension.LANGUAGE);
                    } else if (value.equalsIgnoreCase("Authorization")) {
                        dimensions.add(Dimension.AUTHORIZATION);
                    } else if (value.equalsIgnoreCase("User-Agent")) {
                        dimensions.add(Dimension.CLIENT_AGENT);
                    } else if (value.equals("*")) {
                        dimensions.add(Dimension.UNSPECIFIED);
                    }
                    value = hr.readValue();
                }
                continue;
            }
            if (header.getName().equalsIgnoreCase("Warning")) {
                hr = new WarningReader(header.getValue());
                try {
                    response.getWarnings().add(((WarningReader)hr).readWarning());
                }
                catch (Exception e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Error during warning parsing. Header: " + header.getValue(), e);
                }
                continue;
            }
            if (!header.getName().equalsIgnoreCase("Cache-Control")) continue;
            CacheControlReader ccr = new CacheControlReader(header.getValue());
            try {
                response.getCacheDirectives().addAll(ccr.readDirectives());
            }
            catch (Exception e) {
                Context.getCurrentLogger().log(Level.WARNING, "Error during cache control parsing. Header: " + header.getValue(), e);
            }
        }
    }

    public static String createVaryHeader(Collection<Dimension> dimensions) {
        String vary = null;
        if (dimensions != null && !dimensions.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            if (dimensions.contains((Object)Dimension.CLIENT_ADDRESS) || dimensions.contains((Object)Dimension.TIME) || dimensions.contains((Object)Dimension.UNSPECIFIED)) {
                vary = "*";
            } else {
                for (Dimension dim : dimensions) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    if (dim == Dimension.CHARACTER_SET) {
                        sb.append("Accept-Charset");
                        continue;
                    }
                    if (dim == Dimension.CLIENT_AGENT) {
                        sb.append("User-Agent");
                        continue;
                    }
                    if (dim == Dimension.ENCODING) {
                        sb.append("Accept-Encoding");
                        continue;
                    }
                    if (dim == Dimension.LANGUAGE) {
                        sb.append("Accept-Language");
                        continue;
                    }
                    if (dim == Dimension.MEDIA_TYPE) {
                        sb.append("Accept");
                        continue;
                    }
                    if (dim != Dimension.AUTHORIZATION) continue;
                    sb.append("Authorization");
                }
                vary = sb.toString();
            }
        }
        return vary;
    }

    public static String formatDate(Date date, boolean cookie) {
        if (cookie) {
            return DateUtils.format(date, DateUtils.FORMAT_RFC_1036.get(0));
        }
        return DateUtils.format(date, DateUtils.FORMAT_RFC_1123.get(0));
    }

    public static void formatProduct(CharSequence nameToken, CharSequence versionToken, Appendable destination) throws IOException {
        if (!HeaderUtils.isToken(nameToken)) {
            throw new IllegalArgumentException("Invalid product name detected. Only token characters are allowed.");
        }
        destination.append(nameToken);
        if (versionToken != null) {
            if (!HeaderUtils.isToken(versionToken)) {
                throw new IllegalArgumentException("Invalid product version detected. Only token characters are allowed.");
            }
            destination.append('/').append(versionToken);
        }
    }

    public static long getContentLength(Series<Parameter> headers) {
        long contentLength = -1L;
        if (headers != null) {
            for (Parameter header : headers) {
                if (!header.getName().equalsIgnoreCase("Content-Length")) continue;
                try {
                    contentLength = Long.parseLong(header.getValue());
                }
                catch (NumberFormatException e) {
                    contentLength = -1L;
                }
            }
        }
        return contentLength;
    }

    public static boolean isAlpha(int character) {
        return HeaderUtils.isUpperCase(character) || HeaderUtils.isLowerCase(character);
    }

    public static boolean isAsciiChar(int character) {
        return character >= 0 && character <= 127;
    }

    public static boolean isCarriageReturn(int character) {
        return character == 13;
    }

    public static boolean isChunkedEncoding(Series<Parameter> headers) {
        boolean result = false;
        if (headers != null) {
            String header = headers.getFirstValue("Transfer-Encoding", true);
            result = "chunked".equalsIgnoreCase(header);
        }
        return result;
    }

    public static boolean isCommentText(int character) {
        return HeaderUtils.isText(character) && character != 40 && character != 41;
    }

    public static boolean isConnectionClose(Series<Parameter> headers) {
        boolean result = false;
        if (headers != null) {
            String header = headers.getFirstValue("Connection", true);
            result = "close".equalsIgnoreCase(header);
        }
        return result;
    }

    public static boolean isControlChar(int character) {
        return character >= 0 && character <= 31 || character == 127;
    }

    public static boolean isDigit(int character) {
        return character >= 48 && character <= 57;
    }

    public static boolean isDoubleQuote(int character) {
        return character == 34;
    }

    public static boolean isHorizontalTab(int character) {
        return character == 9;
    }

    public static boolean isLinearWhiteSpace(int character) {
        return HeaderUtils.isCarriageReturn(character) || HeaderUtils.isSpace(character) || HeaderUtils.isLineFeed(character) || HeaderUtils.isHorizontalTab(character);
    }

    public static boolean isLineFeed(int character) {
        return character == 10;
    }

    public static boolean isLowerCase(int character) {
        return character >= 97 && character <= 122;
    }

    public static boolean isQuotedText(int character) {
        return HeaderUtils.isText(character) && !HeaderUtils.isDoubleQuote(character);
    }

    public static boolean isSeparator(int character) {
        switch (character) {
            case 9: 
            case 32: 
            case 34: 
            case 40: 
            case 41: 
            case 44: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 91: 
            case 92: 
            case 93: 
            case 123: 
            case 125: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSpace(int character) {
        return character == 32;
    }

    public static boolean isText(int character) {
        return HeaderUtils.isAsciiChar(character) && !HeaderUtils.isControlChar(character);
    }

    public static boolean isToken(CharSequence token) {
        for (int i = 0; i < token.length(); ++i) {
            if (HeaderUtils.isTokenChar(token.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isTokenChar(int character) {
        return HeaderUtils.isText(character) && !HeaderUtils.isSeparator(character);
    }

    public static boolean isUpperCase(int character) {
        return character >= 65 && character <= 90;
    }

    public static boolean isValueSeparator(int character) {
        return character == 44;
    }

    public static Date parseDate(String date, boolean cookie) {
        if (cookie) {
            return DateUtils.parse(date, DateUtils.FORMAT_RFC_1036);
        }
        return DateUtils.parse(date, DateUtils.FORMAT_RFC_1123);
    }

    public static Parameter readHeader(InputStream is, StringBuilder sb) throws IOException {
        Parameter result = null;
        int next = is.read();
        if (HeaderUtils.isCarriageReturn(next)) {
            next = is.read();
            if (!HeaderUtils.isLineFeed(next)) {
                throw new IOException("Invalid end of headers. Line feed missing after the carriage return.");
            }
        } else {
            result = new Parameter();
            while (next != -1 && next != 58) {
                sb.append((char)next);
                next = is.read();
            }
            if (next == -1) {
                throw new IOException("Unable to parse the header name. End of stream reached too early.");
            }
            result.setName(sb.toString());
            sb.delete(0, sb.length());
            next = is.read();
            while (HeaderUtils.isSpace(next)) {
                next = is.read();
            }
            while (next != -1 && !HeaderUtils.isCarriageReturn(next)) {
                sb.append((char)next);
                next = is.read();
            }
            if (next == -1) {
                throw new IOException("Unable to parse the header value. End of stream reached too early.");
            }
            next = is.read();
            if (HeaderUtils.isLineFeed(next)) {
                result.setValue(sb.toString());
                sb.delete(0, sb.length());
            } else {
                throw new IOException("Unable to parse the HTTP header value. The carriage return must be followed by a line feed.");
            }
        }
        return result;
    }

    public static void writeCRLF(OutputStream os) throws IOException {
        os.write(13);
        os.write(10);
    }

    public static void writeHeader(Parameter header, OutputStream os) throws IOException {
        os.write(header.getName().getBytes());
        os.write(58);
        os.write(32);
        if (header.getValue() != null) {
            os.write(header.getValue().getBytes());
        }
        os.write(13);
        os.write(10);
    }

    private HeaderUtils() {
    }
}

