/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http.io;

import java.io.IOException;
import java.io.InputStream;
import org.restlet.Connector;
import org.restlet.engine.http.connector.Connection;
import org.restlet.engine.http.io.InputEntityStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SizedInputStream
extends InputEntityStream {
    private volatile long availableSize;
    private volatile long markedAvailableSize;

    public SizedInputStream(Connection<? extends Connector> connection, InputStream inboundStream, long size) {
        super(connection, inboundStream);
        this.availableSize = size;
        this.markedAvailableSize = -1L;
    }

    public SizedInputStream(Connection<? extends Connector> connection, long size) {
        this(connection, connection.getInboundStream(), size);
    }

    @Override
    public int available() throws IOException {
        return Math.min((int)this.availableSize, this.getInboundStream().available());
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (this.markSupported()) {
            this.markedAvailableSize = this.availableSize;
        }
        this.getInboundStream().mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.getInboundStream().markSupported();
    }

    @Override
    public int read() throws IOException {
        int result = -1;
        if (this.availableSize > 0L) {
            result = this.getInboundStream().read();
            if (result != -1) {
                --this.availableSize;
            } else {
                this.onEndReached();
            }
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = -1;
        if (this.availableSize > 0L) {
            result = this.getInboundStream().read(b, off, Math.min(len, (int)this.availableSize));
            if (result > 0) {
                this.availableSize -= (long)result;
            } else if (result == -1) {
                this.onEndReached();
            }
        }
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.getInboundStream().read(b);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.markSupported() && this.markedAvailableSize != -1L) {
            this.availableSize = this.markedAvailableSize;
            this.markedAvailableSize = -1L;
        }
        this.getInboundStream().reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.getInboundStream().skip(n);
    }
}

