/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import org.restlet.data.CharacterSet;

public class ReaderInputStream
extends InputStream {
    private final ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
    private final CharBuffer charBuffer;
    private final CharsetEncoder charsetEncoder;
    private volatile boolean endReached;
    private final BufferedReader reader;

    public ReaderInputStream(Reader reader) throws IOException {
        this(reader, CharacterSet.ISO_8859_1);
    }

    public ReaderInputStream(Reader reader, CharacterSet characterSet) throws IOException {
        this.byteBuffer.flip();
        this.charBuffer = CharBuffer.allocate(1024);
        this.charBuffer.flip();
        this.charsetEncoder = characterSet == null ? CharacterSet.ISO_8859_1.toCharset().newEncoder() : characterSet.toCharset().newEncoder();
        this.endReached = false;
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, 8192);
    }

    public int available() throws IOException {
        return this.byteBuffer.hasRemaining() ? this.byteBuffer.remaining() : 0;
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public int read() throws IOException {
        byte[] temp = new byte[1];
        return this.read(temp) == -1 ? -1 : temp[0] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result = 0;
        boolean iterate = true;
        while (iterate) {
            int readLength;
            if (!this.byteBuffer.hasRemaining() && !this.endReached) {
                if (!this.charBuffer.hasRemaining()) {
                    this.charBuffer.clear();
                    int read = this.reader.read(this.charBuffer);
                    this.charBuffer.flip();
                    if (read == -1) {
                        this.endReached = true;
                    }
                }
                if (len > 0 && this.charBuffer.hasRemaining()) {
                    this.byteBuffer.clear();
                    this.charsetEncoder.encode(this.charBuffer, this.byteBuffer, this.endReached);
                    this.byteBuffer.flip();
                }
            }
            if ((readLength = Math.min(len, this.byteBuffer.remaining())) > 0) {
                this.byteBuffer.get(b, off, readLength);
                off += readLength;
                len -= readLength;
                result += readLength;
            }
            iterate = len > 0 && (!this.endReached || this.byteBuffer.hasRemaining() || this.charBuffer.hasRemaining());
        }
        if (this.endReached && result == 0) {
            result = -1;
        }
        return result;
    }
}

