/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.engine.io.NioUtils;
import org.restlet.engine.io.ReadableSelectionChannel;
import org.restlet.engine.io.SelectorFactory;
import org.restlet.util.SelectionListener;
import org.restlet.util.SelectionRegistration;

public class NbChannelInputStream
extends InputStream {
    private final ByteBuffer byteBuffer;
    private final ReadableByteChannel channel;
    private volatile boolean endReached;
    private volatile SelectionRegistration selectionRegistration;
    private final SelectableChannel selectableChannel;
    private final ReadableSelectionChannel selectionChannel;

    public NbChannelInputStream(ReadableByteChannel channel) {
        this.channel = channel;
        if (channel instanceof ReadableSelectionChannel) {
            this.selectionChannel = (ReadableSelectionChannel)channel;
            this.selectableChannel = null;
        } else if (channel instanceof SelectableChannel) {
            this.selectionChannel = null;
            this.selectableChannel = (SelectableChannel)((Object)channel);
        } else {
            this.selectionChannel = null;
            this.selectableChannel = null;
        }
        this.byteBuffer = ByteBuffer.allocate(8192);
        this.byteBuffer.flip();
        this.endReached = false;
        this.selectionRegistration = null;
    }

    public int read() throws IOException {
        int result = -1;
        if (!this.endReached) {
            if (!this.byteBuffer.hasRemaining()) {
                this.refill();
            }
            if (!this.endReached) {
                result = this.byteBuffer.get() & 0xFF;
            }
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result = -1;
        if (!this.endReached) {
            if (!this.byteBuffer.hasRemaining()) {
                this.refill();
            }
            if (!this.endReached) {
                result = Math.min(len, this.byteBuffer.remaining());
                this.byteBuffer.get(b, off, result);
            }
        }
        return result;
    }

    private int readChannel() throws IOException {
        int result = 0;
        this.byteBuffer.clear();
        result = this.channel.read(this.byteBuffer);
        this.byteBuffer.flip();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refill() throws IOException {
        int bytesRead = 0;
        while (bytesRead == 0) {
            bytesRead = this.readChannel();
            if (bytesRead != 0) continue;
            if (this.selectionChannel != null) {
                try {
                    if (this.selectionRegistration == null) {
                        this.selectionRegistration = this.selectionChannel.getRegistration();
                        this.selectionRegistration.setInterestOperations(1);
                        this.selectionRegistration.setListener(new SelectionListener(){

                            public void onSelected(SelectionRegistration registration) {
                                registration.suspend();
                                NbChannelInputStream.this.selectionRegistration.unblock();
                            }
                        });
                    } else {
                        this.selectionRegistration.resume();
                    }
                    this.selectionRegistration.block();
                }
                catch (Exception e) {
                    Context.getCurrentLogger().log(Level.FINE, "Exception while registering or waiting for new content", e);
                }
                bytesRead = this.readChannel();
                continue;
            }
            if (this.selectableChannel == null) continue;
            Selector selector = null;
            SelectionKey selectionKey = null;
            try {
                selector = SelectorFactory.getSelector();
                if (selector != null) {
                    selectionKey = this.selectableChannel.register(selector, 1);
                    selector.select(60000L);
                }
            }
            finally {
                NioUtils.release(selector, selectionKey);
            }
            bytesRead = this.readChannel();
        }
        if (bytesRead == -1) {
            this.endReached = true;
            if (this.selectionRegistration != null) {
                this.selectionRegistration.setCanceling(true);
            }
        }
    }
}

