/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.security;

import java.io.IOException;
import java.util.logging.Logger;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.engine.Helper;
import org.restlet.engine.header.ChallengeWriter;
import org.restlet.engine.header.Header;
import org.restlet.engine.header.HeaderWriter;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AuthenticatorHelper
extends Helper {
    private volatile ChallengeScheme challengeScheme;
    private volatile boolean clientSide;
    private volatile boolean serverSide;

    public AuthenticatorHelper(ChallengeScheme challengeScheme, boolean clientSide, boolean serverSide) {
        this.challengeScheme = challengeScheme;
        this.clientSide = clientSide;
        this.serverSide = serverSide;
    }

    public void formatRawRequest(ChallengeWriter cw, ChallengeRequest challenge, Response response, Series<Header> httpHeaders) throws IOException {
    }

    public void formatRawResponse(ChallengeWriter cw, ChallengeResponse challenge, Request request, Series<Header> httpHeaders) {
    }

    public String formatRequest(ChallengeRequest challenge, Response response, Series<Header> httpHeaders) throws IOException {
        ChallengeWriter cw = new ChallengeWriter();
        ((HeaderWriter)cw.append(challenge.getScheme().getTechnicalName())).appendSpace();
        if (challenge.getRawValue() != null) {
            cw.append(challenge.getRawValue());
        } else {
            this.formatRawRequest(cw, challenge, response, httpHeaders);
        }
        return cw.toString();
    }

    public String formatResponse(ChallengeResponse challenge, Request request, Series<Header> httpHeaders) {
        ChallengeWriter hb = new ChallengeWriter();
        ((HeaderWriter)hb.append(challenge.getScheme().getTechnicalName())).appendSpace();
        if (challenge.getRawValue() != null) {
            hb.append(challenge.getRawValue());
        } else {
            this.formatRawResponse(hb, challenge, request, httpHeaders);
        }
        return hb.toString();
    }

    public char[] formatSecret(ChallengeResponse challengeResponse, Request request, Response response, String identifier, char[] baseSecret, String baseSecretAlgorithm) {
        if (baseSecret != null) {
            return baseSecret;
        }
        return null;
    }

    public ChallengeScheme getChallengeScheme() {
        return this.challengeScheme;
    }

    public Logger getLogger() {
        return Context.getCurrentLogger();
    }

    public boolean isClientSide() {
        return this.clientSide;
    }

    public boolean isServerSide() {
        return this.serverSide;
    }

    public void parseRequest(ChallengeRequest challenge, Response response, Series<Header> httpHeaders) {
    }

    public void parseResponse(ChallengeResponse challenge, Request request, Series<Header> httpHeaders) {
    }

    public void setChallengeScheme(ChallengeScheme challengeScheme) {
        this.challengeScheme = challengeScheme;
    }

    public void setClientSide(boolean clientSide) {
        this.clientSide = clientSide;
    }

    public void setServerSide(boolean serverSide) {
        this.serverSide = serverSide;
    }
}

