/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.odata.internal.edm;

import java.util.ArrayList;
import java.util.List;
import org.restlet.data.Method;
import org.restlet.ext.odata.internal.edm.ComplexType;
import org.restlet.ext.odata.internal.edm.EntitySet;
import org.restlet.ext.odata.internal.edm.EntityType;
import org.restlet.ext.odata.internal.edm.Metadata;
import org.restlet.ext.odata.internal.edm.NamedObject;
import org.restlet.ext.odata.internal.edm.Parameter;
import org.restlet.ext.odata.internal.edm.Schema;

public class FunctionImport
extends NamedObject {
    private EntitySet entitySet;
    private Metadata metadata;
    private Method method;
    private String methodAccess;
    private List<Parameter> parameters;
    private String returnType;

    public FunctionImport(String name) {
        super(name);
    }

    public EntitySet getEntitySet() {
        return this.entitySet;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getMethodAccess() {
        return this.methodAccess;
    }

    public List<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        return this.parameters;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public ComplexType getReturnTypeAsComplexType() {
        ComplexType result = null;
        String rt = this.getSimpleReturnType();
        if (this.getReturnType() != null && this.metadata != null) {
            for (Schema schema : this.metadata.getSchemas()) {
                for (ComplexType complexType : schema.getComplexTypes()) {
                    if (!rt.equalsIgnoreCase(complexType.getName())) continue;
                    result = complexType;
                }
            }
        }
        return result;
    }

    public EntityType getReturnTypeAsEntityType() {
        EntityType result = null;
        String rt = this.getSimpleReturnType();
        if (this.getReturnType() != null && this.metadata != null) {
            for (Schema schema : this.metadata.getSchemas()) {
                for (EntityType entityType : schema.getEntityTypes()) {
                    if (!rt.equalsIgnoreCase(entityType.getName())) continue;
                    result = entityType;
                }
            }
        }
        return result;
    }

    public String getSimpleReturnType() {
        return this.returnType;
    }

    public boolean isReturningCollection() {
        return this.getReturnType() != null && this.getReturnType().toLowerCase().startsWith("collection(");
    }

    public boolean isReturningComplexType() {
        return this.getReturnTypeAsComplexType() != null;
    }

    public boolean isReturningEdmSimpleType() {
        return this.getReturnType() != null && this.getReturnType().toLowerCase().startsWith("edm.");
    }

    public boolean isReturningEntityType() {
        return this.getReturnType() != null && this.getReturnType().toLowerCase().startsWith("edm.");
    }

    public void setEntitySet(EntitySet entitySet) {
        this.entitySet = entitySet;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setMethodAccess(String methodAccess) {
        this.methodAccess = methodAccess;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }
}

