/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.rdf;

import org.restlet.data.Reference;
import org.restlet.ext.rdf.Graph;
import org.restlet.ext.rdf.Literal;

public class Link {
    private volatile Object source;
    private volatile Reference typeRef;
    private volatile Object target;

    public static Reference createBlankRef(String identifier) {
        return new Reference("_:" + identifier);
    }

    public static boolean isBlankRef(Reference reference) {
        return reference != null && "_".equals(reference.getScheme());
    }

    public Link(Graph sourceGraph, Reference typeRef, Literal targetLit) {
        this((Object)sourceGraph, typeRef, (Object)targetLit);
    }

    public Link(Graph sourceGraph, Reference typeRef, Object target) {
        this((Object)sourceGraph, typeRef, target);
    }

    public Link(Graph sourceGraph, Reference typeRef, Reference targetRef) {
        this(sourceGraph, typeRef, (Object)targetRef);
    }

    public Link(Graph sourceGraph, String typeRef, Literal targetLit) {
        this(sourceGraph, new Reference(typeRef), targetLit);
    }

    public Link(Graph sourceGraph, String typeRef, Object target) {
        this(sourceGraph, new Reference(typeRef), target);
    }

    public Link(Graph sourceGraph, String typeRef, Reference targetRef) {
        this(sourceGraph, new Reference(typeRef), targetRef);
    }

    public Link(Link from) {
        this(from.getSource(), from.getTypeRef(), from.getTarget());
    }

    private Link(Object source, Reference typeRef, Object target) {
        this.source = source;
        this.typeRef = typeRef;
        this.target = target;
    }

    public Link(Reference sourceRef, Reference typeRef, Literal targetLit) {
        this((Object)sourceRef, typeRef, (Object)targetLit);
    }

    public Link(Reference sourceRef, Reference typeRef, Reference targetRef) {
        this((Object)sourceRef, typeRef, (Object)targetRef);
    }

    public Link(Reference sourceRef, String typeRef, Literal targetLit) {
        this(sourceRef, new Reference(typeRef), targetLit);
    }

    public Link(Reference sourceRef, String typeRef, Reference targetRef) {
        this(sourceRef, new Reference(typeRef), targetRef);
    }

    public Object getSource() {
        return this.source;
    }

    public Graph getSourceAsGraph() {
        return this.hasGraphSource() ? (Graph)this.getSource() : null;
    }

    public Link getSourceAsLink() {
        return this.hasLinkSource() ? (Link)this.getSource() : null;
    }

    public Reference getSourceAsReference() {
        return this.hasReferenceSource() ? (Reference)this.getSource() : null;
    }

    public Object getTarget() {
        return this.target;
    }

    public Graph getTargetAsGraph() {
        return this.hasGraphTarget() ? (Graph)this.getTarget() : null;
    }

    public Link getTargetAsLink() {
        return this.hasLinkTarget() ? (Link)this.getTarget() : null;
    }

    public Literal getTargetAsLiteral() {
        return this.hasLiteralTarget() ? (Literal)this.getTarget() : null;
    }

    public Reference getTargetAsReference() {
        return this.hasReferenceTarget() ? (Reference)this.getTarget() : null;
    }

    public Reference getTypeRef() {
        return this.typeRef;
    }

    public boolean hasGraphSource() {
        return this.getSource() instanceof Graph;
    }

    public boolean hasGraphTarget() {
        return this.getTarget() instanceof Graph;
    }

    public boolean hasLinkSource() {
        return this.getSource() instanceof Link;
    }

    public boolean hasLinkTarget() {
        return this.getTarget() instanceof Link;
    }

    public boolean hasLiteralTarget() {
        return this.getTarget() instanceof Literal;
    }

    public boolean hasReferenceSource() {
        return this.getSource() instanceof Reference;
    }

    public boolean hasReferenceTarget() {
        return this.getTarget() instanceof Reference;
    }

    public void setSource(Graph sourceGraph) {
        this.source = sourceGraph;
    }

    public void setSource(Link sourceLink) {
        this.source = sourceLink;
    }

    public void setSource(Reference sourceRef) {
        this.source = sourceRef;
    }

    public void setTarget(Graph targetGraph) {
        this.target = targetGraph;
    }

    public void setTarget(Link targetLink) {
        this.target = targetLink;
    }

    public void setTarget(Literal targetLit) {
        this.target = targetLit;
    }

    public void setTarget(Reference targetRef) {
        this.target = targetRef;
    }

    public void setTypeRef(Reference typeRef) {
        this.typeRef = typeRef;
    }
}

