/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.wadl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.engine.resource.AnnotationInfo;
import org.restlet.engine.resource.AnnotationUtils;
import org.restlet.ext.wadl.DocumentationInfo;
import org.restlet.ext.wadl.DocumentedInfo;
import org.restlet.ext.wadl.RepresentationInfo;
import org.restlet.ext.wadl.RequestInfo;
import org.restlet.ext.wadl.ResponseInfo;
import org.restlet.ext.wadl.WadlServerResource;
import org.restlet.ext.xml.XmlWriter;
import org.restlet.representation.Variant;
import org.restlet.resource.ServerResource;
import org.restlet.service.MetadataService;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInfo
extends DocumentedInfo {
    private String identifier;
    private Method name;
    private RequestInfo request;
    private List<ResponseInfo> responses;
    private Reference targetRef;

    public static void describeAnnotations(MethodInfo info, ServerResource resource) {
        List annotations;
        MetadataService metadataService = resource.getMetadataService();
        List list = annotations = resource.isAnnotated() ? AnnotationUtils.getAnnotations(resource.getClass()) : null;
        if (annotations != null && metadataService != null) {
            for (AnnotationInfo annotationInfo : annotations) {
                List responseVariants;
                Class outputClass;
                if (!info.getName().equals((Object)annotationInfo.getRestletMethod())) continue;
                Class[] classes = annotationInfo.getJavaInputTypes();
                List requestVariants = annotationInfo.getRequestVariants(resource.getMetadataService(), resource.getConverterService());
                if (requestVariants != null) {
                    for (Variant variant : requestVariants) {
                        if (variant.getMediaType() == null || info.getRequest() != null && info.getRequest().getRepresentations().contains(variant)) continue;
                        RepresentationInfo representationInfo = null;
                        if (info.getRequest() == null) {
                            info.setRequest(new RequestInfo());
                        }
                        representationInfo = resource instanceof WadlServerResource ? ((WadlServerResource)resource).describe(info, info.getRequest(), classes[0], variant) : new RepresentationInfo(variant);
                        info.getRequest().getRepresentations().add(representationInfo);
                    }
                }
                if ((outputClass = annotationInfo.getJavaOutputType()) == null || (responseVariants = annotationInfo.getResponseVariants(resource.getMetadataService(), resource.getConverterService())) == null) continue;
                for (Variant variant : responseVariants) {
                    if (variant.getMediaType() == null || info.getResponse().getRepresentations().contains(variant)) continue;
                    RepresentationInfo representationInfo = null;
                    representationInfo = resource instanceof WadlServerResource ? ((WadlServerResource)resource).describe(info, info.getResponse(), outputClass, variant) : new RepresentationInfo(variant);
                    info.getResponse().getRepresentations().add(representationInfo);
                }
            }
        }
    }

    public MethodInfo() {
    }

    public MethodInfo(DocumentationInfo documentation) {
        super(documentation);
    }

    public MethodInfo(List<DocumentationInfo> documentations) {
        super(documentations);
    }

    public MethodInfo(String documentation) {
        super(documentation);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Method getName() {
        return this.name;
    }

    public RequestInfo getRequest() {
        return this.request;
    }

    public ResponseInfo getResponse() {
        if (this.getResponses().isEmpty()) {
            this.getResponses().add(new ResponseInfo());
        }
        return this.getResponses().get(this.getResponses().size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResponseInfo> getResponses() {
        List<ResponseInfo> r = this.responses;
        if (r == null) {
            MethodInfo methodInfo = this;
            synchronized (methodInfo) {
                r = this.responses;
                if (r == null) {
                    this.responses = r = new ArrayList<ResponseInfo>();
                }
            }
        }
        return r;
    }

    public Reference getTargetRef() {
        return this.targetRef;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setName(Method name) {
        this.name = name;
    }

    public void setRequest(RequestInfo request) {
        this.request = request;
    }

    public void setResponses(List<ResponseInfo> responses) {
        this.responses = responses;
    }

    public void setTargetRef(Reference targetRef) {
        this.targetRef = targetRef;
    }

    @Override
    public void updateNamespaces(Map<String, String> namespaces) {
        namespaces.putAll(this.resolveNamespaces());
        if (this.getRequest() != null) {
            this.getRequest().updateNamespaces(namespaces);
        }
        if (!this.getResponses().isEmpty()) {
            for (ResponseInfo response : this.getResponses()) {
                response.updateNamespaces(namespaces);
            }
        }
    }

    public void writeElement(XmlWriter writer) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        if (this.getIdentifier() != null && !this.getIdentifier().equals("")) {
            attributes.addAttribute("", "id", null, "xs:ID", this.getIdentifier());
        }
        if (this.getName() != null && this.getName().toString() != null) {
            attributes.addAttribute("", "name", null, "xs:NMTOKEN", this.getName().toString());
        }
        if (this.getTargetRef() != null && this.getTargetRef().toString() != null) {
            attributes.addAttribute("", "href", null, "xs:anyURI", this.getTargetRef().toString());
        }
        if (this.getDocumentations().isEmpty() && this.getRequest() == null && this.getResponses().isEmpty()) {
            writer.emptyElement("http://wadl.dev.java.net/2009/02", "method", null, (Attributes)attributes);
        } else {
            writer.startElement("http://wadl.dev.java.net/2009/02", "method", null, (Attributes)attributes);
            for (DocumentationInfo documentationInfo : this.getDocumentations()) {
                documentationInfo.writeElement(writer);
            }
            if (this.getRequest() != null) {
                this.getRequest().writeElement(writer);
            }
            if (!this.getResponses().isEmpty()) {
                for (ResponseInfo response : this.getResponses()) {
                    response.writeElement(writer);
                }
            }
            writer.endElement("http://wadl.dev.java.net/2009/02", "method");
        }
    }
}

