/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.wadl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.restlet.data.Reference;
import org.restlet.ext.wadl.DocumentationInfo;
import org.restlet.ext.wadl.DocumentedInfo;
import org.restlet.ext.wadl.ResourceInfo;
import org.restlet.ext.xml.XmlWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcesInfo
extends DocumentedInfo {
    private Reference baseRef;
    private List<ResourceInfo> resources;

    public ResourcesInfo() {
    }

    public ResourcesInfo(DocumentationInfo documentation) {
        super(documentation);
    }

    public ResourcesInfo(List<DocumentationInfo> documentations) {
        super(documentations);
    }

    public ResourcesInfo(String documentation) {
        super(documentation);
    }

    public Reference getBaseRef() {
        return this.baseRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceInfo> getResources() {
        List<ResourceInfo> r = this.resources;
        if (r == null) {
            ResourcesInfo resourcesInfo = this;
            synchronized (resourcesInfo) {
                r = this.resources;
                if (r == null) {
                    this.resources = r = new ArrayList<ResourceInfo>();
                }
            }
        }
        return r;
    }

    public void setBaseRef(Reference baseRef) {
        this.baseRef = baseRef;
    }

    public void setResources(List<ResourceInfo> resources) {
        this.resources = resources;
    }

    @Override
    public void updateNamespaces(Map<String, String> namespaces) {
        namespaces.putAll(this.resolveNamespaces());
        for (ResourceInfo resourceInfo : this.getResources()) {
            resourceInfo.updateNamespaces(namespaces);
        }
    }

    public void writeElement(XmlWriter writer) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        if (this.getBaseRef() != null) {
            attributes.addAttribute("", "base", null, "xs:anyURI", this.getBaseRef().toString());
        }
        if (this.getDocumentations().isEmpty() && this.getResources().isEmpty()) {
            writer.emptyElement("http://wadl.dev.java.net/2009/02", "resources", null, (Attributes)attributes);
        } else {
            writer.startElement("http://wadl.dev.java.net/2009/02", "resources", null, (Attributes)attributes);
            for (DocumentationInfo documentationInfo : this.getDocumentations()) {
                documentationInfo.writeElement(writer);
            }
            for (ResourceInfo resourceInfo : this.getResources()) {
                resourceInfo.writeElement(writer);
            }
            writer.endElement("http://wadl.dev.java.net/2009/02", "resources");
        }
    }
}

