/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Server;
import org.restlet.engine.Engine;
import org.restlet.engine.ServerHelper;
import org.restlet.engine.http.HttpRequest;
import org.restlet.engine.http.HttpResponse;
import org.restlet.engine.http.HttpServerAdapter;
import org.restlet.engine.http.HttpServerCall;

public class HttpServerHelper
extends ServerHelper {
    private volatile HttpServerAdapter converter = null;

    public HttpServerHelper() {
        this(null);
    }

    public HttpServerHelper(Server server) {
        super(server);
    }

    public HttpServerAdapter getConverter() {
        if (this.converter == null) {
            try {
                String converterClass = this.getHelpedParameters().getFirstValue("converter", "org.restlet.engine.http.HttpServerAdapter");
                this.converter = (HttpServerAdapter)Engine.loadClass(converterClass).getConstructor(Context.class).newInstance(this.getContext());
            }
            catch (IllegalArgumentException e) {
                this.getLogger().log(Level.SEVERE, "Unable to create the HTTP server converter", e);
            }
            catch (SecurityException e) {
                this.getLogger().log(Level.SEVERE, "Unable to create the HTTP server converter", e);
            }
            catch (InstantiationException e) {
                this.getLogger().log(Level.SEVERE, "Unable to create the HTTP server converter", e);
            }
            catch (IllegalAccessException e) {
                this.getLogger().log(Level.SEVERE, "Unable to create the HTTP server converter", e);
            }
            catch (InvocationTargetException e) {
                this.getLogger().log(Level.SEVERE, "Unable to create the HTTP server converter", e);
            }
            catch (NoSuchMethodException e) {
                this.getLogger().log(Level.SEVERE, "Unable to create the HTTP server converter", e);
            }
            catch (ClassNotFoundException e) {
                this.getLogger().log(Level.SEVERE, "Unable to create the HTTP server converter", e);
            }
        }
        return this.converter;
    }

    public void handle(HttpServerCall httpCall) {
        try {
            HttpRequest request = this.getConverter().toRequest(httpCall);
            HttpResponse response = new HttpResponse(httpCall, request);
            this.handle(request, response);
            this.getConverter().commit(response);
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Error while handling an HTTP server call: ", e.getMessage());
            this.getLogger().log(Level.INFO, "Error while handling an HTTP server call", e);
        }
    }

    public void setConverter(HttpServerAdapter converter) {
        this.converter = converter;
    }
}

