/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.security;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Parameter;
import org.restlet.data.Request;
import org.restlet.engine.security.AuthenticatorHelper;
import org.restlet.engine.util.Base64;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpBasicHelper
extends AuthenticatorHelper {
    public HttpBasicHelper() {
        super(ChallengeScheme.HTTP_BASIC, true, true);
    }

    @Override
    public void formatCredentials(StringBuilder sb, ChallengeResponse challenge, Request request, Series<Parameter> httpHeaders) {
        try {
            CharArrayWriter credentials = new CharArrayWriter();
            credentials.write(challenge.getIdentifier());
            credentials.write(":");
            credentials.write(challenge.getSecret());
            sb.append(Base64.encode(credentials.toCharArray(), "US-ASCII", false));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding, unable to encode credentials");
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception, unable to encode credentials", e);
        }
    }

    @Override
    public void parseResponse(ChallengeResponse cr, Request request) {
        try {
            String credentials;
            int separator;
            byte[] credentialsEncoded = Base64.decode(cr.getCredentials());
            if (credentialsEncoded == null) {
                this.getLogger().warning("Cannot decode credentials: " + cr.getCredentials());
            }
            if ((separator = (credentials = new String(credentialsEncoded, "US-ASCII")).indexOf(58)) == -1) {
                this.getLogger().warning("Invalid credentials given by client with IP: " + (request != null ? request.getClientInfo().getAddress() : "?"));
            } else {
                cr.setIdentifier(credentials.substring(0, separator));
                cr.setSecret(credentials.substring(separator + 1));
            }
        }
        catch (UnsupportedEncodingException e) {
            this.getLogger().log(Level.WARNING, "Unsupported encoding error", e);
        }
    }
}

