/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.security;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.security.Authorizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodAuthorizer
extends Authorizer {
    private final List<Method> anonymousMethods = new CopyOnWriteArrayList<Method>();
    private final List<Method> authenticatedMethods = new CopyOnWriteArrayList<Method>();

    public MethodAuthorizer() {
        this((String)null);
    }

    public MethodAuthorizer(String identifier) {
        super(identifier);
    }

    @Override
    public boolean authorize(Request request, Response response) {
        boolean authorized = false;
        if (request.getClientInfo().isAuthenticated()) {
            for (Method authenticatedMethod : this.getAuthenticatedMethods()) {
                authorized = authorized || request.getMethod().equals(authenticatedMethod);
            }
        } else {
            for (Method authorizedMethod : this.getAnonymousMethods()) {
                authorized = authorized || request.getMethod().equals(authorizedMethod);
            }
        }
        return authorized;
    }

    public List<Method> getAnonymousMethods() {
        return this.anonymousMethods;
    }

    public List<Method> getAuthenticatedMethods() {
        return this.authenticatedMethods;
    }
}

