/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.Status;
import org.restlet.engine.Engine;
import org.restlet.engine.component.ChildContext;

public abstract class Restlet
implements Uniform {
    private static final String UNABLE_TO_START = "Unable to start the Restlet";
    private volatile String author;
    private volatile Context context;
    private volatile String description;
    private volatile String name;
    private volatile String owner;
    private volatile boolean started;

    public Restlet() {
        this(null);
    }

    public Restlet(Context context) {
        this.context = context;
        this.started = false;
        this.name = null;
        this.description = null;
        this.author = null;
        this.owner = null;
        if (Engine.getInstance() == null) {
            Context.getCurrentLogger().severe("Unable to fully initialize the Restlet. No Restlet engine available.");
            throw new RuntimeException("Unable to fully initialize the Restlet. No Restlet engine available.");
        }
        ChildContext.fireContextChanged(this, context);
    }

    public Application getApplication() {
        return Application.getCurrent();
    }

    public String getAuthor() {
        return this.author;
    }

    public Context getContext() {
        return this.context;
    }

    public String getDescription() {
        return this.description;
    }

    public Logger getLogger() {
        Logger result = null;
        Context context = this.getContext();
        if (context == null) {
            context = Context.getCurrent();
        }
        if (context != null) {
            result = context.getLogger();
        }
        if (result == null) {
            result = Logger.getLogger(this.getClass().getCanonicalName());
        }
        if (result == null) {
            result = Logger.getLogger("org.restlet.Restlet");
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public void handle(Request request, Response response) {
        Response.setCurrent(response);
        if (this.getContext() != null) {
            Context.setCurrent(this.getContext());
        }
        if (this.isStopped()) {
            try {
                this.start();
            }
            catch (Exception e) {
                this.getContext().getLogger().log(Level.WARNING, UNABLE_TO_START, e);
                response.setStatus(Status.SERVER_ERROR_INTERNAL);
            }
            if (!this.isStarted()) {
                this.getContext().getLogger().log(Level.WARNING, UNABLE_TO_START);
                response.setStatus(Status.SERVER_ERROR_INTERNAL);
            }
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isStopped() {
        return !this.started;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setContext(Context context) {
        this.context = context;
        ChildContext.fireContextChanged(this, context);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public synchronized void start() throws Exception {
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        this.started = false;
    }
}

