/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.component;

import java.util.Iterator;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.engine.ChainHelper;
import org.restlet.engine.component.ClientRouter;
import org.restlet.engine.component.ComponentContext;
import org.restlet.engine.component.ServerRouter;
import org.restlet.routing.Route;
import org.restlet.routing.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentHelper
extends ChainHelper<Component> {
    private final ClientRouter clientRouter;
    private volatile ServerRouter serverRouter;

    public ComponentHelper(Component component) {
        super(component);
        component.setContext(new ComponentContext(this));
        this.clientRouter = new ClientRouter((Component)this.getHelped());
        this.serverRouter = new ServerRouter((Component)this.getHelped());
    }

    private boolean checkVirtualHost(VirtualHost host) throws Exception {
        boolean result = true;
        if (host != null) {
            for (Route route : host.getRoutes()) {
                Restlet next = route.getNext();
                if (!(next instanceof Application)) continue;
                Application application = (Application)next;
                if (application.getConnectorService() != null) {
                    Iterator iter;
                    if (application.getConnectorService().getClientProtocols() != null) {
                        for (Protocol clientProtocol : application.getConnectorService().getClientProtocols()) {
                            boolean clientFound = false;
                            iter = ((Component)this.getHelped()).getClients().iterator();
                            while (!clientFound && iter.hasNext()) {
                                Client client = (Client)iter.next();
                                clientFound = client.getProtocols().contains(clientProtocol);
                            }
                            if (clientFound) continue;
                            this.getLogger().severe("Unable to start the application \"" + application.getName() + "\". Client connector for protocol " + clientProtocol.getName() + " is missing.");
                            result = false;
                        }
                    }
                    if (application.getConnectorService().getServerProtocols() != null) {
                        for (Protocol serverProtocol : application.getConnectorService().getServerProtocols()) {
                            boolean serverFound = false;
                            iter = ((Component)this.getHelped()).getServers().iterator();
                            while (!serverFound && iter.hasNext()) {
                                Server server = (Server)iter.next();
                                serverFound = server.getProtocols().contains(serverProtocol);
                            }
                            if (serverFound) continue;
                            this.getLogger().severe("Unable to start the application \"" + application.getName() + "\". Server connector for protocol " + serverProtocol.getName() + " is missing.");
                            result = false;
                        }
                    }
                }
                if (!result || !application.isStopped()) continue;
                application.start();
            }
        }
        return result;
    }

    public ClientRouter getClientRouter() {
        return this.clientRouter;
    }

    public ServerRouter getServerRouter() {
        return this.serverRouter;
    }

    public void setServerRouter(ServerRouter serverRouter) {
        this.serverRouter = serverRouter;
    }

    @Override
    public synchronized void start() throws Exception {
        boolean success = this.checkVirtualHost(((Component)this.getHelped()).getDefaultHost());
        if (success) {
            for (VirtualHost host : ((Component)this.getHelped()).getHosts()) {
                success = success && this.checkVirtualHost(host);
            }
        }
        if (!success) {
            ((Component)this.getHelped()).stop();
        } else {
            if (((Component)this.getHelped()).getLogService().isEnabled()) {
                this.addFilter(((Component)this.getHelped()).getLogService().createInboundFilter(this.getContext().createChildContext()));
            }
            if (((Component)this.getHelped()).getStatusService().isEnabled()) {
                this.addFilter(((Component)this.getHelped()).getStatusService().createInboundFilter(this.getContext().createChildContext()));
            }
            this.setNext(this.getServerRouter());
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        this.getServerRouter().stop();
        this.stopVirtualHostApplications(((Component)this.getHelped()).getDefaultHost());
        for (VirtualHost host : ((Component)this.getHelped()).getHosts()) {
            this.stopVirtualHostApplications(host);
        }
    }

    private void stopVirtualHostApplications(VirtualHost host) throws Exception {
        for (Route route : host.getRoutes()) {
            if (!route.getNext().isStarted()) continue;
            route.getNext().stop();
        }
    }

    @Override
    public void update() throws Exception {
        ServerRouter oldRouter = this.getServerRouter();
        this.setServerRouter(new ServerRouter((Component)this.getHelped()));
        this.setNext(this.getServerRouter());
        if (oldRouter != null) {
            oldRouter.stop();
        }
    }
}

