/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class ChunkedInputStream
extends InputStream {
    private static final int PUSHBBACK_BUFFER_SIZE = 2;
    private volatile long chunkSize;
    private volatile boolean endReached;
    private volatile boolean initialized;
    private volatile long position;
    private final PushbackInputStream source;

    public ChunkedInputStream(InputStream source) {
        this.source = new PushbackInputStream(source, 2);
        this.initialized = false;
        this.endReached = false;
        this.position = 0L;
        this.chunkSize = 0L;
    }

    private boolean canRead() throws IOException {
        boolean result = false;
        this.initialize();
        if (!this.endReached) {
            if (!this.chunkAvailable()) {
                this.initializeChunk();
            }
            result = !this.endReached;
        }
        return result;
    }

    private void checkCRLF() throws IOException {
        int cr = this.source.read();
        int lf = this.source.read();
        if (cr != 13 && lf != 10) {
            this.source.unread(lf);
            this.source.unread(cr);
        }
    }

    private boolean chunkAvailable() {
        return this.position < this.chunkSize;
    }

    public void close() throws IOException {
        super.close();
        this.initialized = true;
        this.endReached = true;
    }

    private void initialize() throws IOException {
        if (!this.initialized) {
            this.checkCRLF();
            this.initialized = true;
        }
    }

    private void initializeChunk() throws IOException {
        this.chunkSize = this.readChunkSize();
        this.position = 0L;
        if (this.chunkSize == 0L) {
            this.endReached = true;
            this.checkCRLF();
        }
    }

    public int read() throws IOException {
        int result = -1;
        if (this.canRead()) {
            result = this.source.read();
            ++this.position;
            this.endReached = result == -1;
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result = -1;
        if (this.canRead()) {
            int nextResult;
            result = this.source.read(b, off, Math.min(len, (int)(this.chunkSize - this.position)));
            this.position += (long)result;
            if (len - result > 0 && (nextResult = this.read(b, off + result, len - result)) > 0) {
                result += nextResult;
            }
        }
        return result;
    }

    private long readChunkSize() throws IOException {
        String line = this.readChunkSizeLine();
        int index = line.indexOf(59);
        line = index == -1 ? line : line.substring(0, index);
        try {
            return Long.parseLong(line.trim(), 16);
        }
        catch (NumberFormatException ex) {
            throw new IOException("<" + line + "> is an invalid chunk size");
        }
    }

    private String readChunkSizeLine() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.checkCRLF();
        while (true) {
            int b;
            if ((b = this.source.read()) == -1) {
                throw new IOException("Invalid chunk size specified. End of stream reached");
            }
            if (b == 13) {
                int lf = this.source.read();
                if (lf == 10) break;
                throw new IOException("Invalid chunk size specified.  Expected crlf, only saw cr");
            }
            buffer.write(b);
        }
        return new String(buffer.toByteArray());
    }
}

