/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.security;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.restlet.Request;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Parameter;
import org.restlet.engine.security.AuthenticatorHelper;
import org.restlet.engine.util.Base64;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmtpPlainHelper
extends AuthenticatorHelper {
    public SmtpPlainHelper() {
        super(ChallengeScheme.SMTP_PLAIN, true, false);
    }

    @Override
    public void formatCredentials(StringBuilder sb, ChallengeResponse challenge, Request request, Series<Parameter> httpHeaders) {
        try {
            CharArrayWriter credentials = new CharArrayWriter();
            credentials.write("^@");
            credentials.write(challenge.getIdentifier());
            credentials.write("^@");
            credentials.write(challenge.getSecret());
            sb.append(Base64.encode(credentials.toCharArray(), "US-ASCII", false));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding, unable to encode credentials");
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception, unable to encode credentials", e);
        }
    }
}

