/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.engine.Engine;
import org.restlet.engine.RestletHelper;
import org.restlet.engine.application.ApplicationHelper;
import org.restlet.engine.resource.AnnotationUtils;
import org.restlet.resource.Finder;
import org.restlet.security.Role;
import org.restlet.service.ConnectorService;
import org.restlet.service.ConverterService;
import org.restlet.service.DecoderService;
import org.restlet.service.MetadataService;
import org.restlet.service.RangeService;
import org.restlet.service.StatusService;
import org.restlet.service.TunnelService;
import org.restlet.util.ServiceList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application
extends Restlet {
    private static final ThreadLocal<Application> CURRENT = new ThreadLocal();
    private volatile Class<? extends Finder> finderClass;
    private volatile RestletHelper<Application> helper;
    private final List<Role> roles;
    private volatile Restlet inboundRoot;
    private volatile Restlet outboundRoot;
    private final ServiceList services;

    public static Application getCurrent() {
        return CURRENT.get();
    }

    public static void setCurrent(Application application) {
        CURRENT.set(application);
    }

    public Application() {
        this(null);
    }

    public Application(Context context) {
        super(context);
        if (Engine.getInstance() != null) {
            this.helper = new ApplicationHelper(this);
        }
        this.outboundRoot = null;
        this.inboundRoot = null;
        this.roles = new CopyOnWriteArrayList<Role>();
        this.services = new ServiceList(context);
        this.services.add(new TunnelService(true, true));
        this.services.add(new StatusService());
        this.services.add(new DecoderService());
        this.services.add(new RangeService());
        this.services.add(new ConnectorService());
        this.services.add(new ConverterService());
        this.services.add(new MetadataService());
    }

    public Restlet createInboundRoot() {
        return null;
    }

    public Restlet createOutboundRoot() {
        return this.getContext() != null ? this.getContext().getClientDispatcher() : null;
    }

    @Deprecated
    public Restlet createRoot() {
        return this.createInboundRoot();
    }

    public ConnectorService getConnectorService() {
        return this.getServices().get(ConnectorService.class);
    }

    public ConverterService getConverterService() {
        return this.getServices().get(ConverterService.class);
    }

    public DecoderService getDecoderService() {
        return this.getServices().get(DecoderService.class);
    }

    public Class<? extends Finder> getFinderClass() {
        return this.finderClass;
    }

    private RestletHelper<Application> getHelper() {
        return this.helper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Restlet getInboundRoot() {
        if (this.inboundRoot == null) {
            Application application = this;
            synchronized (application) {
                if (this.inboundRoot == null) {
                    this.inboundRoot = this.createRoot();
                }
            }
        }
        return this.inboundRoot;
    }

    public MetadataService getMetadataService() {
        return this.getServices().get(MetadataService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Restlet getOutboundRoot() {
        if (this.outboundRoot == null) {
            Application application = this;
            synchronized (application) {
                if (this.outboundRoot == null) {
                    this.outboundRoot = this.createOutboundRoot();
                }
            }
        }
        return this.outboundRoot;
    }

    public RangeService getRangeService() {
        return this.getServices().get(RangeService.class);
    }

    public Role getRole(String name) {
        for (Role role : this.getRoles()) {
            if (!role.getName().equals(name)) continue;
            return role;
        }
        return null;
    }

    public List<Role> getRoles() {
        return this.roles;
    }

    @Deprecated
    public synchronized Restlet getRoot() {
        return this.getInboundRoot();
    }

    public ServiceList getServices() {
        return this.services;
    }

    public StatusService getStatusService() {
        return this.getServices().get(StatusService.class);
    }

    public TunnelService getTunnelService() {
        return this.getServices().get(TunnelService.class);
    }

    @Override
    public void handle(Request request, Response response) {
        super.handle(request, response);
        if (this.getHelper() != null) {
            this.getHelper().handle(request, response);
        }
    }

    public synchronized void setClientRoot(Class<?> clientRootClass) {
        this.setOutboundRoot(Finder.createFinder(clientRootClass, this.getFinderClass(), this.getContext(), this.getLogger()));
    }

    public void setConnectorService(ConnectorService connectorService) {
        this.getServices().set(connectorService);
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
        this.getServices().setContext(context);
    }

    public void setConverterService(ConverterService converterService) {
        this.getServices().set(converterService);
    }

    public void setDecoderService(DecoderService decoderService) {
        this.getServices().set(decoderService);
    }

    public void setFinderClass(Class<? extends Finder> finderClass) {
        this.finderClass = finderClass;
    }

    public synchronized void setInboundRoot(Class<?> inboundRootClass) {
        this.setInboundRoot(Finder.createFinder(inboundRootClass, this.getFinderClass(), this.getContext(), this.getLogger()));
    }

    public synchronized void setInboundRoot(Restlet inboundRoot) {
        this.inboundRoot = inboundRoot;
        if (inboundRoot != null && inboundRoot.getContext() == null) {
            inboundRoot.setContext(this.getContext());
        }
    }

    public void setMetadataService(MetadataService metadataService) {
        this.getServices().set(metadataService);
    }

    public synchronized void setOutboundRoot(Restlet outboundRoot) {
        this.outboundRoot = outboundRoot;
        if (outboundRoot != null && outboundRoot.getContext() == null) {
            outboundRoot.setContext(this.getContext());
        }
    }

    public void setRangeService(RangeService rangeService) {
        this.getServices().set(rangeService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRoles(List<Role> roles) {
        List<Role> list = this.getRoles();
        synchronized (list) {
            if (roles != this.getRoles()) {
                this.getRoles().clear();
                if (roles != null) {
                    this.getRoles().addAll(roles);
                }
            }
        }
    }

    @Deprecated
    public synchronized void setRoot(Class<?> inboundRootClass) {
        this.setInboundRoot(inboundRootClass);
    }

    @Deprecated
    public synchronized void setRoot(Restlet inboundRoot) {
        this.setInboundRoot(inboundRoot);
    }

    public void setStatusService(StatusService statusService) {
        this.getServices().set(statusService);
    }

    public void setTunnelService(TunnelService tunnelService) {
        this.getServices().set(tunnelService);
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.isStopped()) {
            super.start();
            if (this.getHelper() != null) {
                this.getHelper().start();
            }
            this.getServices().start();
            if (this.getInboundRoot() != null) {
                this.getInboundRoot().start();
            }
            if (this.getOutboundRoot() != null) {
                this.getOutboundRoot().start();
            }
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        if (this.isStarted()) {
            if (this.getOutboundRoot() != null) {
                this.getOutboundRoot().stop();
            }
            if (this.getInboundRoot() != null) {
                this.getInboundRoot().stop();
            }
            this.getServices().stop();
            if (this.getHelper() != null) {
                this.getHelper().stop();
            }
            AnnotationUtils.clearCache();
            super.stop();
        }
    }
}

