/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.Arrays;
import java.util.List;
import org.restlet.Connector;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Protocol;
import org.restlet.engine.Engine;
import org.restlet.engine.RestletHelper;
import org.restlet.resource.Finder;
import org.restlet.resource.ServerResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
extends Connector {
    private volatile String address;
    private final RestletHelper<Server> helper;
    private volatile Restlet next;
    private volatile int port;

    public Server(Context context, List<Protocol> protocols, int port, Restlet next) {
        this(context, protocols, null, port, next);
    }

    public Server(Context context, List<Protocol> protocols, String address, int port, Restlet next) {
        this(context, protocols, address, port, next, null);
    }

    public Server(Context context, List<Protocol> protocols, String address, int port, Restlet next, String helperClass) {
        super(context, protocols);
        this.address = address;
        this.port = port;
        this.next = next;
        this.helper = Engine.getInstance() != null ? Engine.getInstance().createHelper(this, helperClass) : null;
        if (context != null && this.helper != null) {
            context.getAttributes().put("org.restlet.engine.helper", this.helper);
        }
    }

    public Server(Context context, Protocol protocol, Class<? extends ServerResource> nextClass) {
        this(context, protocol, null, protocol == null ? -1 : protocol.getDefaultPort(), (Restlet)new Finder(Context.getCurrent(), nextClass));
    }

    public Server(Context context, Protocol protocol, int port) {
        this(context, protocol, port, (Restlet)null);
    }

    public Server(Context context, Protocol protocol, int port, Class<? extends ServerResource> nextClass) {
        this(context, protocol, null, port, (Restlet)new Finder(Context.getCurrent(), nextClass));
    }

    public Server(Context context, Protocol protocol, int port, Restlet next) {
        this(context, protocol, null, port, next);
    }

    public Server(Context context, Protocol protocol, Restlet next) {
        this(context, protocol, null, protocol == null ? -1 : protocol.getDefaultPort(), next);
    }

    public Server(Context context, Protocol protocol, String address, int port, Restlet next) {
        this(context, protocol == null ? null : Arrays.asList(protocol), address, port, next);
    }

    public Server(List<Protocol> protocols, int port, Restlet next) {
        this((Context)null, protocols, port, next);
    }

    public Server(List<Protocol> protocols, String address, int port, Restlet next) {
        this((Context)null, protocols, address, port, next);
    }

    public Server(Protocol protocol) {
        this((Context)null, protocol, (Restlet)null);
    }

    public Server(Protocol protocol, Class<? extends ServerResource> nextClass) {
        this((Context)null, protocol, (Restlet)new Finder(Context.getCurrent(), nextClass));
    }

    public Server(Protocol protocol, int port) {
        this((Context)null, protocol, port, (Restlet)null);
    }

    public Server(Protocol protocol, int port, Class<? extends ServerResource> nextClass) {
        this((Context)null, protocol, port, (Restlet)new Finder(Context.getCurrent(), nextClass));
    }

    public Server(Protocol protocol, int port, Restlet next) {
        this((Context)null, protocol, port, next);
    }

    public Server(Protocol protocol, Restlet next) {
        this((Context)null, protocol, next);
    }

    public Server(Protocol protocol, String address) {
        this((Context)null, protocol, address, protocol.getDefaultPort(), null);
    }

    public Server(Protocol protocol, String address, Class<? extends ServerResource> nextClass) {
        this((Context)null, protocol, address, protocol.getDefaultPort(), (Restlet)new Finder(Context.getCurrent(), nextClass));
    }

    public Server(Protocol protocol, String address, int port) {
        this((Context)null, protocol, address, port, null);
    }

    public Server(Protocol protocol, String address, int port, Restlet next) {
        this((Context)null, protocol, address, port, next);
    }

    public Server(Protocol protocol, String address, Restlet next) {
        this((Context)null, protocol, address, protocol.getDefaultPort(), next);
    }

    public int getActualPort() {
        return this.getPort() == 0 ? this.getEphemeralPort() : this.getPort();
    }

    public String getAddress() {
        return this.address;
    }

    public int getEphemeralPort() {
        return (Integer)this.getHelper().getAttributes().get("ephemeralPort");
    }

    private RestletHelper<Server> getHelper() {
        return this.helper;
    }

    public Restlet getNext() {
        return this.next;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void handle(Request request, Response response) {
        super.handle(request, response);
        if (this.getNext() != null) {
            this.getNext().handle(request, response);
        }
    }

    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public boolean isAvailable() {
        return this.getHelper() != null;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setNext(Class<? extends ServerResource> nextClass) {
        this.setNext(new Finder(this.getContext(), nextClass));
    }

    public void setNext(Restlet next) {
        this.next = next;
    }

    protected void setPort(int port) {
        this.port = port;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.isStopped()) {
            super.start();
            if (this.getHelper() != null) {
                this.getHelper().start();
            }
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        if (this.isStarted()) {
            if (this.getHelper() != null) {
                this.getHelper().stop();
            }
            super.stop();
        }
    }
}

