/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.atom;

import java.util.List;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.ext.atom.Categories;
import org.restlet.ext.atom.Feed;
import org.restlet.ext.atom.Workspace;
import org.restlet.ext.xml.XmlWriter;
import org.restlet.representation.Representation;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Collection {
    private volatile List<MediaType> accept;
    private volatile Reference baseReference;
    private volatile Categories categories;
    private volatile Reference href;
    private volatile String title;
    private volatile Workspace workspace;

    public Collection(Workspace workspace, String title, String href) {
        this.workspace = workspace;
        this.title = title;
        this.href = new Reference(href);
        this.accept = null;
        this.categories = null;
    }

    public List<MediaType> getAccept() {
        return this.accept;
    }

    public Reference getBaseReference() {
        return this.baseReference;
    }

    public Categories getCategories() {
        return this.categories;
    }

    public Feed getFeed() throws Exception {
        Reference feedRef = this.getHref();
        if (feedRef.isRelative()) {
            feedRef.setBaseRef(this.getWorkspace().getService().getReference());
        }
        Request request = new Request(Method.GET, feedRef.getTargetRef());
        Response response = this.getWorkspace().getService().getClientDispatcher().handle(request);
        if (response.getStatus().equals((Object)Status.SUCCESS_OK)) {
            return new Feed(response.getEntity());
        }
        throw new Exception("Couldn't get the feed representation. Status returned: " + response.getStatus());
    }

    public Reference getHref() {
        return this.href;
    }

    public String getTitle() {
        return this.title;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public Reference postMember(Representation member) throws Exception {
        Request request = new Request(Method.POST, this.getHref(), member);
        Response response = this.getWorkspace().getService().getClientDispatcher().handle(request);
        if (response.getStatus().equals((Object)Status.SUCCESS_CREATED)) {
            return response.getLocationRef();
        }
        throw new Exception("Couldn't post the member representation. Status returned: " + response.getStatus());
    }

    public void setAccept(List<MediaType> accept) {
        this.accept = accept;
    }

    public void setBaseReference(Reference baseReference) {
        this.baseReference = baseReference;
    }

    public void setCategories(Categories categories) {
        this.categories = categories;
    }

    public void setHref(Reference href) {
        this.href = href;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public void writeElement(XmlWriter writer) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        if (this.getHref() != null && this.getHref().toString() != null) {
            attributes.addAttribute("", "href", null, "atomURI", this.getHref().toString());
        }
        writer.startElement("http://www.w3.org/2007/app", "collection", null, (Attributes)attributes);
        if (this.getTitle() != null) {
            writer.dataElement("http://www.w3.org/2005/Atom", "title", this.getTitle());
        }
        if (this.getAccept() != null) {
            StringBuilder sb = new StringBuilder();
            for (MediaType mediaType : this.getAccept()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(mediaType.toString());
            }
            writer.dataElement("http://www.w3.org/2007/app", "accept", sb.toString());
        }
        try {
            if (this.getCategories() != null) {
                this.getCategories().writeElement(writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        writer.endElement("http://www.w3.org/2007/app", "collection");
    }
}

