/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.javamail;

import java.io.IOException;
import java.util.Date;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import org.restlet.data.MediaType;
import org.restlet.engine.http.ContentType;
import org.restlet.engine.util.DateUtils;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.InputRepresentation;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MessageRepresentation
extends DomRepresentation {
    public MessageRepresentation(Message message) throws IOException, DOMException, MessagingException {
        super(MediaType.APPLICATION_XML);
        ContentType contentType;
        Address[] bccs;
        Address[] ccs;
        Address[] tos;
        Address[] froms;
        Document dom = this.getDocument();
        Element email = dom.createElement("email");
        dom.appendChild(email);
        Element head = dom.createElement("head");
        email.appendChild(head);
        if (message.getSubject() != null) {
            Element subject = dom.createElement("subject");
            subject.setTextContent(message.getSubject());
            head.appendChild(subject);
        }
        if ((froms = message.getFrom()) != null) {
            for (Address fromAddress : froms) {
                Element from = dom.createElement("from");
                from.setTextContent(fromAddress.toString());
                head.appendChild(from);
            }
        }
        if ((tos = message.getRecipients(Message.RecipientType.TO)) != null) {
            for (Address toAddress : tos) {
                Element to = dom.createElement("to");
                to.setTextContent(toAddress.toString());
                head.appendChild(to);
            }
        }
        if ((ccs = message.getRecipients(Message.RecipientType.CC)) != null) {
            for (Address ccAddress : ccs) {
                Element cc = dom.createElement("cc");
                cc.setTextContent(ccAddress.toString());
                head.appendChild(cc);
            }
        }
        if ((bccs = message.getRecipients(Message.RecipientType.BCC)) != null) {
            for (Address bccAddress : bccs) {
                Element bcc = dom.createElement("bcc");
                bcc.setTextContent(bccAddress.toString());
                head.appendChild(bcc);
            }
        }
        if (message.getReceivedDate() != null) {
            Element received = dom.createElement("received");
            received.setTextContent(DateUtils.format((Date)message.getReceivedDate(), (String)((String)DateUtils.FORMAT_RFC_1123.get(0))));
            head.appendChild(received);
        }
        if (message.getSentDate() != null) {
            Element sent = dom.createElement("sent");
            sent.setTextContent(DateUtils.format((Date)message.getSentDate(), (String)((String)DateUtils.FORMAT_RFC_1123.get(0))));
            head.appendChild(sent);
        }
        email.appendChild(head);
        InputRepresentation content = null;
        if (message.getContent() instanceof Multipart) {
            Multipart multipart = (Multipart)message.getContent();
            int n = multipart.getCount();
            for (int i = 0; i < n; ++i) {
                BodyPart part = multipart.getBodyPart(i);
                String disposition = part.getDisposition();
                if (disposition != null) {
                    if (disposition.equals("attachment") || !disposition.equals("inline")) continue;
                    continue;
                }
                MimeBodyPart mimeBodyPart = (MimeBodyPart)part;
                ContentType contentType2 = new ContentType(mimeBodyPart.getContentType());
                if (!MediaType.TEXT_PLAIN.equals((Object)contentType2.getMediaType(), true)) continue;
                content = new InputRepresentation(mimeBodyPart.getInputStream(), MediaType.TEXT_PLAIN);
                break;
            }
        } else if (message.getContentType() != null && MediaType.TEXT_PLAIN.equals((Object)(contentType = new ContentType(message.getContentType())).getMediaType(), true)) {
            content = new InputRepresentation(message.getInputStream(), MediaType.TEXT_PLAIN);
        }
        if (content != null) {
            Element body = dom.createElement("body");
            CDATASection bodyContent = dom.createCDATASection(content.getText());
            body.appendChild(bodyContent);
            email.appendChild(body);
        }
    }
}

