/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs;

import java.util.Collection;
import java.util.Set;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.ext.jaxrs.JaxRsRestlet;
import org.restlet.ext.jaxrs.ObjectFactory;
import org.restlet.ext.jaxrs.RoleChecker;
import org.restlet.routing.Filter;
import org.restlet.security.Authenticator;
import org.restlet.security.Guard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxRsApplication
extends Application {
    private volatile Filter guard;
    private volatile JaxRsRestlet jaxRsRestlet;

    public JaxRsApplication() {
        this((Context)null);
    }

    public JaxRsApplication(Context context) {
        super(context);
        this.jaxRsRestlet = new JaxRsRestlet(context, this.getMetadataService());
    }

    public JaxRsApplication(javax.ws.rs.core.Application appConfig) throws IllegalArgumentException {
        this.add(appConfig);
    }

    public boolean add(javax.ws.rs.core.Application appConfig) throws IllegalArgumentException {
        if (appConfig == null) {
            throw new IllegalArgumentException("The ApplicationConfig must not be null");
        }
        JaxRsRestlet jaxRsRestlet = this.jaxRsRestlet;
        Set classes = appConfig.getClasses();
        Set singletons = appConfig.getSingletons();
        boolean everythingFine = true;
        if (singletons != null) {
            for (Object singleton : singletons) {
                if (singleton == null || classes.contains(singleton.getClass())) continue;
                everythingFine &= jaxRsRestlet.addSingleton(singleton);
            }
        }
        if (classes != null) {
            for (Class clazz : classes) {
                everythingFine &= jaxRsRestlet.addClass(clazz);
            }
        }
        return everythingFine;
    }

    public Restlet createInboundRoot() {
        JaxRsRestlet restlet = this.jaxRsRestlet;
        if (this.guard != null) {
            this.guard.setNext((Restlet)restlet);
            restlet = this.guard;
        }
        return restlet;
    }

    public Filter getGuard() {
        return this.guard;
    }

    public JaxRsRestlet getJaxRsRestlet() {
        return this.jaxRsRestlet;
    }

    public ObjectFactory getObjectFactory() {
        return this.jaxRsRestlet.getObjectFactory();
    }

    @Deprecated
    public RoleChecker getRoleChecker() {
        return this.jaxRsRestlet.getRoleChecker();
    }

    public Collection<Class<?>> getRootResources() {
        return this.jaxRsRestlet.getRootResourceClasses();
    }

    public Collection<String> getRootUris() {
        return this.jaxRsRestlet.getRootUris();
    }

    public void setApplications(Collection<javax.ws.rs.core.Application> apps) {
        for (javax.ws.rs.core.Application app : apps) {
            this.add(app);
        }
    }

    @Deprecated
    public void setAuthentication(Authenticator guard, RoleChecker roleChecker) {
        this.setGuard(guard);
        this.setRoleChecker(roleChecker);
    }

    public void setContext(Context context) {
        super.setContext(context);
        this.jaxRsRestlet.setContext(context);
    }

    @Deprecated
    public void setGuard(Guard guard) {
        this.guard = guard;
    }

    public void setGuard(Authenticator guard) {
        this.guard = guard;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.jaxRsRestlet.setObjectFactory(objectFactory);
    }

    @Deprecated
    public void setRoleChecker(RoleChecker roleChecker) {
        this.jaxRsRestlet.setRoleChecker(roleChecker);
    }
}

