/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.openid.internal;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Cookie;
import org.restlet.data.CookieSetting;
import org.restlet.data.Method;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.ext.openid.internal.CacheLookup;
import org.restlet.representation.Representation;
import org.restlet.routing.Filter;
import org.restlet.routing.Redirector;

@Deprecated
public class CallbackCacheFilter
extends Filter
implements CacheLookup {
    public static final String EXTERNAL_SERVER_COOKIE = "callback";
    public static final String INTERNAL_SERVER_COOKIE = "auth-callback";
    public static final String UserCookieID = "_uid";
    private SecureRandom random;
    private ConcurrentHashMap<String, String> userCache = new ConcurrentHashMap();

    public CallbackCacheFilter(Context context) {
        super(context);
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    protected void afterHandle(Request request, Response response) {
        Representation r;
        Cookie c = (Cookie)request.getCookies().getFirst(UserCookieID);
        if (c != null && (r = response.getEntity()) != null && r instanceof JsonRepresentation) {
            JsonRepresentation jr = (JsonRepresentation)r;
            try {
                JSONObject o = jr.getJsonObject();
                if (o != null && o.has("id")) {
                    String id = o.getString("id");
                    this.getLogger().fine("Caching JSON id = " + id);
                    this.userCache.put(c.getValue(), id);
                    this.createResponse(id, request, response);
                    this.clearCookies(response);
                }
            }
            catch (JSONException ignore) {
                // empty catch block
            }
        }
    }

    private void clearCookies(Response response) {
        response.getCookieSettings().removeAll(EXTERNAL_SERVER_COOKIE);
        response.getCookieSettings().removeAll(INTERNAL_SERVER_COOKIE);
        CookieSetting clear = new CookieSetting(EXTERNAL_SERVER_COOKIE, "");
        clear.setMaxAge(0);
        response.getCookieSettings().add((Object)clear);
        CookieSetting clear2 = new CookieSetting(INTERNAL_SERVER_COOKIE, "");
        clear2.setMaxAge(0);
        response.getCookieSettings().add((Object)clear2);
    }

    private void createResponse(String id, Request request, Response response) {
        String callback = response.getCookieSettings().getFirstValue(INTERNAL_SERVER_COOKIE);
        if (callback == null) {
            callback = request.getCookies().getFirstValue(INTERNAL_SERVER_COOKIE);
        }
        if (callback != null) {
            Redirector dispatcher = new Redirector(this.getContext(), callback, 4);
            this.getContext().getAttributes().put("id", id);
            dispatcher.handle(request, response);
            response.getCookieSettings().remove((Object)INTERNAL_SERVER_COOKIE);
        } else {
            JSONObject obj = new JSONObject();
            try {
                obj.put("id", (Object)id);
            }
            catch (JSONException e) {
                this.getLogger().log(Level.WARNING, "Failed to get the ID!", e);
            }
            String jcallback = response.getCookieSettings().getFirstValue(EXTERNAL_SERVER_COOKIE);
            if (jcallback == null) {
                jcallback = request.getCookies().getFirstValue(EXTERNAL_SERVER_COOKIE);
            }
            if (jcallback != null) {
                Redirector dispatcher = new Redirector(this.getContext(), jcallback, 6);
                request.setEntity((Representation)new JsonRepresentation(obj));
                request.setMethod(Method.POST);
                dispatcher.handle(request, response);
                response.getCookieSettings().remove((Object)EXTERNAL_SERVER_COOKIE);
            } else {
                response.setEntity((Representation)new JsonRepresentation(obj));
            }
        }
    }

    protected int doHandle(Request request, Response response) {
        Cookie c = (Cookie)request.getCookies().getFirst(UserCookieID);
        if (c == null) {
            String key = this.generate(40);
            CookieSetting cs = new CookieSetting(UserCookieID, key);
            response.getCookieSettings().add((Object)cs);
            this.userCache.put(key, "");
        }
        return super.doHandle(request, response);
    }

    private String generate(int len) {
        byte[] token = new byte[len];
        this.random.nextBytes(token);
        return this.toHex(token);
    }

    public boolean handleCached(Request request, Response response) {
        String key;
        Cookie c = (Cookie)request.getCookies().getFirst(UserCookieID);
        if (c != null && (key = c.getValue()) != null && key.length() > 0 && this.userCache.containsKey(key)) {
            this.createResponse(this.userCache.get(key), request, response);
            this.clearCookies(response);
            return true;
        }
        return false;
    }

    private String toHex(byte[] input) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < input.length; ++i) {
            String d = Integer.toHexString(new Byte(input[i]).intValue() & 0xFF);
            if (d.length() == 1) {
                sb.append('0');
            }
            sb.append(d);
        }
        return sb.toString();
    }
}

