/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.sdc;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.engine.RestletHelper;
import org.restlet.engine.adapter.ClientCall;
import org.restlet.engine.adapter.HttpClientHelper;
import org.restlet.engine.io.IoUtils;
import org.restlet.engine.util.ReferenceUtils;
import org.restlet.ext.sdc.internal.SdcClientCall;
import org.restlet.ext.sdc.internal.SdcServerConnection;
import org.restlet.ext.ssl.SslContextFactory;
import org.restlet.ext.ssl.internal.SslUtils;

public class SdcClientHelper
extends HttpClientHelper {
    private final Map<String, SdcServerConnection> connections;
    private final CountDownLatch latch;
    private final ExecutorService workerService;

    public SdcClientHelper(Client client) {
        super(client);
        this.getProtocols().add(Protocol.valueOf((String)"SDC"));
        this.connections = new ConcurrentHashMap<String, SdcServerConnection>();
        this.workerService = Executors.newCachedThreadPool();
        this.latch = new CountDownLatch(1);
    }

    public ClientCall create(Request request) {
        SdcClientCall result = null;
        try {
            ChallengeResponse cr = request.getProxyChallengeResponse();
            if (cr != null && cr.getScheme().equals((Object)ChallengeScheme.valueOf((String)"SDC"))) {
                String key = cr.getIdentifier() + ":" + String.valueOf(cr.getSecret());
                int retryAttempts = 3;
                int retryDelay = 3000;
                SdcServerConnection ssc = null;
                for (int i = 0; ssc == null && i < retryAttempts; ++i) {
                    ssc = this.getConnections().get(key);
                    if (ssc != null) continue;
                    try {
                        Thread.sleep(retryDelay);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (ssc == null) {
                    this.getLogger().log(Level.WARNING, "Unable to find an established SDC tunnel for this request: ", request.getResourceRef());
                } else {
                    result = new SdcClientCall(this, ssc, request.getMethod().toString(), ReferenceUtils.update((Reference)request.getResourceRef(), (Request)request).toString());
                }
            }
        }
        catch (IOException ioe) {
            this.getLogger().log(Level.WARNING, "Unable to create the HTTP client call", ioe);
        }
        return result;
    }

    public Map<String, SdcServerConnection> getConnections() {
        return this.connections;
    }

    public String[] getEnabledCipherSuites() {
        return this.getHelpedParameters().getValuesArray("enabledCipherSuites", "TLS_RSA_WITH_AES_128_CBC_SHA");
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    public int getServerPort() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("serverPort", "4433"));
    }

    public ExecutorService getWorkerService() {
        return this.workerService;
    }

    public synchronized void start() throws Exception {
        super.start();
        this.getLogger().info("Starting the SDC client and its tunnel server on port " + this.getServerPort());
        new Thread(){

            @Override
            public void run() {
                try {
                    SslContextFactory contextFactory = SslUtils.getSslContextFactory((RestletHelper)SdcClientHelper.this);
                    SSLServerSocketFactory ssf = contextFactory.createSslContext().getServerSocketFactory();
                    SSLServerSocket serverSocket = (SSLServerSocket)ssf.createServerSocket(SdcClientHelper.this.getServerPort());
                    boolean loop = true;
                    SSLSocket socket = null;
                    SdcClientHelper.this.getLatch().countDown();
                    while (loop) {
                        try {
                            socket = (SSLSocket)serverSocket.accept();
                            socket.setEnabledCipherSuites(SdcClientHelper.this.getEnabledCipherSuites());
                            SdcServerConnection ssc = new SdcServerConnection(SdcClientHelper.this, socket);
                            ssc.connect();
                            if (ssc.getKey() != null) {
                                SdcClientHelper.this.getConnections().put(ssc.getKey(), ssc);
                                continue;
                            }
                            SdcClientHelper.this.getLogger().warning("Detected wrong connection.");
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
        try {
            if (!this.getLatch().await(IoUtils.TIMEOUT_MS, TimeUnit.MILLISECONDS)) {
                this.getLogger().warning("The calling thread timed out while waiting for the connector to be ready to accept connections.");
            }
        }
        catch (InterruptedException ex) {
            this.getLogger().log(Level.WARNING, "Interrupted while waiting for starting latch. Stopping...", ex);
            this.stop();
        }
    }

    public synchronized void stop() throws Exception {
        super.stop();
        this.getLogger().info("Stopping the SDC client and its tunnel server");
    }
}

