/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.spring;

import java.util.ArrayList;
import java.util.List;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.data.Method;
import org.restlet.ext.spring.SpringResource;
import org.restlet.representation.Representation;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.PropertiesBeanDefinitionReader;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringContext
extends GenericApplicationContext {
    private volatile Context restletContext;
    private volatile List<String> propertyConfigRefs;
    private volatile List<String> xmlConfigRefs;
    private volatile boolean loaded;

    public SpringContext(Context restletContext) {
        this.restletContext = restletContext;
        this.propertyConfigRefs = null;
        this.xmlConfigRefs = null;
        this.loaded = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPropertyConfigRefs() {
        List<String> p = this.propertyConfigRefs;
        if (p == null) {
            SpringContext springContext = this;
            synchronized (springContext) {
                p = this.propertyConfigRefs;
                if (p == null) {
                    this.propertyConfigRefs = p = new ArrayList<String>();
                }
            }
        }
        return p;
    }

    public Context getRestletContext() {
        return this.restletContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getXmlConfigRefs() {
        List<String> x = this.xmlConfigRefs;
        if (x == null) {
            SpringContext springContext = this;
            synchronized (springContext) {
                x = this.xmlConfigRefs;
                if (x == null) {
                    this.xmlConfigRefs = x = new ArrayList<String>();
                }
            }
        }
        return x;
    }

    public void refresh() {
        if (!this.loaded) {
            Representation config = null;
            PropertiesBeanDefinitionReader propReader = null;
            for (String ref : this.getPropertyConfigRefs()) {
                config = this.getRestletContext().getClientDispatcher().handle(new Request(Method.GET, ref)).getEntity();
                if (config == null) continue;
                propReader = new PropertiesBeanDefinitionReader((BeanDefinitionRegistry)this);
                propReader.loadBeanDefinitions((Resource)new SpringResource(config));
            }
            XmlBeanDefinitionReader xmlReader = null;
            for (String ref : this.getXmlConfigRefs()) {
                config = this.getRestletContext().getClientDispatcher().handle(new Request(Method.GET, ref)).getEntity();
                if (config == null) continue;
                xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)this);
                xmlReader.setValidationMode(3);
                xmlReader.loadBeanDefinitions((Resource)new SpringResource(config));
            }
        }
        super.refresh();
    }
}

