/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.spring;

import org.restlet.Context;
import org.restlet.ext.spring.SpringFinder;
import org.restlet.resource.ServerResource;
import org.restlet.routing.Router;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringBeanFinder
extends SpringFinder
implements BeanFactoryAware,
ApplicationContextAware {
    private volatile ApplicationContext applicationContext;
    private volatile BeanFactory beanFactory;
    private volatile String beanName;
    private volatile Router router;

    public SpringBeanFinder() {
    }

    public SpringBeanFinder(Router router, BeanFactory beanFactory, String beanName) {
        this.router = router;
        this.setBeanFactory(beanFactory);
        this.setBeanName(beanName);
    }

    @Override
    public ServerResource create() {
        Object resource = this.findBean();
        if (!(resource instanceof ServerResource)) {
            throw new ClassCastException(this.getBeanName() + " does not resolve to an instance of " + ServerResource.class.getName());
        }
        return (ServerResource)resource;
    }

    private Object findBean() {
        if (this.getBeanFactory() == null && this.getApplicationContext() == null) {
            throw new IllegalStateException("Either a beanFactory or an applicationContext is required for SpringBeanFinder.");
        }
        if (this.getApplicationContext() != null && this.getApplicationContext().containsBean(this.getBeanName())) {
            return this.getApplicationContext().getBean(this.getBeanName());
        }
        if (this.getBeanFactory() != null && this.getBeanFactory().containsBean(this.getBeanName())) {
            return this.getBeanFactory().getBean(this.getBeanName());
        }
        throw new IllegalStateException(String.format("No bean named %s present.", this.getBeanName()));
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public Context getContext() {
        return this.getRouter() == null ? Context.getCurrent() : this.getRouter().getContext();
    }

    public Router getRouter() {
        return this.router;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setRouter(Router router) {
        this.router = router;
    }
}

